/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.util.List;
import java.util.Properties;
import org.apache.openaz.pepapi.ObligationStoreAware;
import org.apache.openaz.pepapi.PepAgent;
import org.apache.openaz.pepapi.PepAgentFactory;
import org.apache.openaz.pepapi.PepConfig;
import org.apache.openaz.pepapi.PepException;
import org.apache.openaz.pepapi.std.PepUtils;
import org.apache.openaz.pepapi.std.StdPepAgent;
import org.apache.openaz.pepapi.std.StdPepConfig;
import org.apache.openaz.xacml.api.pdp.PDPEngineFactory;
import org.apache.openaz.xacml.util.FactoryException;

public class StdPepAgentFactory
implements PepAgentFactory {
    private volatile PepAgent pepAgent;
    private PDPEngineFactory pdpEngineFactory;
    private Properties xacmlProperties;
    private PepConfig pepConfig;
    private List<ObligationStoreAware> obligationHandlers;

    public StdPepAgentFactory(String propertyFile) {
        this(PepUtils.loadProperties(propertyFile));
    }

    public StdPepAgentFactory(Properties properties) {
        this.xacmlProperties = properties;
        this.pepConfig = new StdPepConfig(properties);
        try {
            this.pdpEngineFactory = PDPEngineFactory.newInstance((Properties)properties);
        }
        catch (FactoryException e) {
            throw new PepException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PepAgent getPepAgent() {
        if (this.pepAgent == null) {
            StdPepAgentFactory stdPepAgentFactory = this;
            synchronized (stdPepAgentFactory) {
                if (this.pepAgent == null) {
                    StdPepAgent pa = new StdPepAgent();
                    pa.setPepConfig(this.pepConfig);
                    pa.setXacmlProperties(this.xacmlProperties);
                    pa.setPdpEngineFactory(this.pdpEngineFactory);
                    pa.setObligationHandlers(this.obligationHandlers);
                    pa.initialize();
                    this.pepAgent = pa;
                }
            }
        }
        return this.pepAgent;
    }

    public void setObligationHandlers(List<ObligationStoreAware> obligationHandlers) {
        this.obligationHandlers = obligationHandlers;
    }
}

