/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openaz.pepapi.MapperRegistry;
import org.apache.openaz.pepapi.ObjectMapper;
import org.apache.openaz.pepapi.PepConfig;
import org.apache.openaz.pepapi.PepRequest;
import org.apache.openaz.pepapi.PepRequestAttributes;
import org.apache.openaz.pepapi.std.StdPepRequestAttributes;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.std.StdMutableRequest;

final class StdPepRequest
implements PepRequest {
    private static final String REQUEST_ATTR_ID_PREFIX = "attributes";
    private final StdMutableRequest wrappedRequest;
    private final Map<Identifier, PepRequestAttributes> pepRequestAttributesMapByCategory;
    private final MapperRegistry mapperRegistry;
    private final PepConfig pepConfig;
    private final Object[] requestObjects;
    private final AtomicInteger idCounter;

    static StdPepRequest newInstance(PepConfig pepConfig, MapperRegistry mapperRegistry, Object[] requestObjects) {
        StdPepRequest stdPepRequest = new StdPepRequest(pepConfig, mapperRegistry, requestObjects);
        stdPepRequest.map();
        return stdPepRequest;
    }

    private String generateRequestAttributesXmlId() {
        return REQUEST_ATTR_ID_PREFIX + this.idCounter.getAndIncrement();
    }

    private StdPepRequest(PepConfig pepConfig, MapperRegistry mapperRegistry, Object[] requestObjects) {
        this.pepConfig = pepConfig;
        this.mapperRegistry = mapperRegistry;
        this.requestObjects = requestObjects;
        this.pepRequestAttributesMapByCategory = new HashMap<Identifier, PepRequestAttributes>();
        this.idCounter = new AtomicInteger(1);
        this.wrappedRequest = new StdMutableRequest();
    }

    @Override
    public PepRequestAttributes getPepRequestAttributes(Identifier categoryIdentifier) {
        PepRequestAttributes pepRequestAttributes = this.pepRequestAttributesMapByCategory.get(categoryIdentifier);
        if (pepRequestAttributes == null) {
            String xmlId = this.generateRequestAttributesXmlId();
            StdPepRequestAttributes p = new StdPepRequestAttributes(xmlId, categoryIdentifier);
            p.setIssuer(this.pepConfig.getIssuer());
            pepRequestAttributes = p;
            this.pepRequestAttributesMapByCategory.put(categoryIdentifier, pepRequestAttributes);
            this.wrappedRequest.add(pepRequestAttributes.getWrappedRequestAttributes());
        }
        return pepRequestAttributes;
    }

    private void map() {
        if (this.requestObjects == null) {
            throw new IllegalArgumentException("One or more arguments are null");
        }
        for (Object o : this.requestObjects) {
            if (o == null) {
                throw new IllegalArgumentException("One or more arguments are null");
            }
            ObjectMapper mapper = this.mapperRegistry.getMapper(o.getClass());
            if (mapper == null) {
                throw new IllegalArgumentException("No mappers found for class: " + o.getClass().getName());
            }
            mapper.map(o, this);
        }
    }

    @Override
    public Request getWrappedRequest() {
        return this.wrappedRequest;
    }
}

