/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.pap.PAPEngine;
import org.apache.openaz.xacml.api.pap.PAPEngineFactory;
import org.apache.openaz.xacml.api.pap.PAPException;
import org.apache.openaz.xacml.api.pap.PDP;
import org.apache.openaz.xacml.api.pap.PDPGroup;
import org.apache.openaz.xacml.api.pap.PDPPolicy;
import org.apache.openaz.xacml.api.pap.PDPStatus;
import org.apache.openaz.xacml.rest.XACMLRest;
import org.apache.openaz.xacml.std.pap.StdPDP;
import org.apache.openaz.xacml.std.pap.StdPDPGroup;
import org.apache.openaz.xacml.std.pap.StdPDPItemSetChangeNotifier;
import org.apache.openaz.xacml.std.pap.StdPDPStatus;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.XACMLProperties;

@WebServlet(description="Implements the XACML PAP RESTful API.", urlPatterns={"/"}, loadOnStartup=1, initParams={@WebInitParam(name="XACML_PROPERTIES_NAME", value="xacml.pap.properties", description="The location of the properties file holding configuration information.")})
public class XACMLPapServlet
extends HttpServlet
implements StdPDPItemSetChangeNotifier.StdItemSetChangeListener,
Runnable {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(XACMLPapServlet.class);
    private PAPEngine papEngine = null;
    private static String papURL = null;
    private static final CopyOnWriteArrayList<String> adminConsoleURLStringList = new CopyOnWriteArrayList();
    private Thread initiateThread = null;
    private static Heartbeat heartbeat = null;
    private static Thread heartbeatThread = null;

    public void init(ServletConfig config) throws ServletException {
        try {
            XACMLRest.xacmlInit((ServletConfig)config);
            XACMLRest.loadXacmlProperties(null, null);
            PAPEngineFactory factory = PAPEngineFactory.newInstance((String)XACMLProperties.getProperty((String)"xacml.PAP.papEngineFactory"));
            this.papEngine = factory.newEngine();
            papURL = XACMLProperties.getProperty((String)"xacml.rest.pap.url");
            if (papURL == null) {
                throw new PAPException("The property xacml.rest.pap.url is not valid: " + papURL);
            }
            if (Boolean.parseBoolean(XACMLProperties.getProperty((String)"xacml.rest.pap.initiate.pdp"))) {
                this.initiateThread = new Thread(this);
                this.initiateThread.start();
            }
            heartbeat = new Heartbeat(this.papEngine);
            heartbeatThread = new Thread(heartbeat);
            heartbeatThread.start();
        }
        catch (PAPException | FactoryException e) {
            logger.error((Object)"Failed to create engine", e);
            throw new ServletException("PAP not initialized; error: " + e);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create engine - unexpected error: ", (Throwable)e);
            throw new ServletException("PAP not initialized; unexpected error: " + e);
        }
    }

    @Override
    public void run() {
        this.changed();
    }

    public void destroy() {
        if (heartbeatThread != null) {
            try {
                if (heartbeat != null) {
                    heartbeat.terminate();
                }
                heartbeatThread.interrupt();
                heartbeatThread.join();
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
        if (this.initiateThread != null) {
            try {
                this.initiateThread.interrupt();
                this.initiateThread.join();
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            PDPGroup group;
            XACMLRest.dumpRequest((HttpServletRequest)request);
            request.getInputStream();
            String groupId = request.getParameter("groupId");
            if (groupId != null) {
                this.doACPost(request, response, groupId);
                return;
            }
            String id = this.getPDPID(request);
            logger.info((Object)("doPost from: " + id));
            PDP pdp = this.papEngine.getPDP(id);
            if (pdp == null) {
                logger.info((Object)("Unknown PDP: " + id));
                try {
                    this.papEngine.newPDP(id, this.papEngine.getDefaultGroup(), id, "Registered on first startup");
                }
                catch (NullPointerException | PAPException e) {
                    logger.error((Object)"Failed to create new PDP", e);
                    response.sendError(500, e.getMessage());
                    return;
                }
                pdp = this.papEngine.getPDP(id);
                if (pdp == null) {
                    String message = "Failed to create new PDP for id: " + id;
                    logger.error((Object)message);
                    response.sendError(500, message);
                    return;
                }
            }
            if ((group = this.papEngine.getPDPGroup(pdp)) == null) {
                response.sendError(401, "PDP not associated with any group, even the default");
                return;
            }
            Properties policies = group.getPolicyProperties();
            Properties pipconfig = group.getPipConfigProperties();
            Properties pdpProperties = new Properties();
            pdpProperties.load((InputStream)request.getInputStream());
            logger.info((Object)("PDP Current Properties: " + pdpProperties.toString()));
            logger.info((Object)("Policies: " + (policies != null ? policies.toString() : "null")));
            logger.info((Object)("Pip config: " + (pipconfig != null ? pipconfig.toString() : "null")));
            boolean isCurrent = this.isPDPCurrent(policies, pipconfig, pdpProperties);
            if (!isCurrent) {
                logger.info((Object)"PDP configuration NOT current.");
                if (policies != null) {
                    this.populatePolicyURL(request.getRequestURL(), policies);
                    policies.store((OutputStream)response.getOutputStream(), "");
                }
                if (pipconfig != null) {
                    pipconfig.store((OutputStream)response.getOutputStream(), "");
                }
                response.setStatus(200);
                this.setPDPSummaryStatus(pdp, PDPStatus.Status.OUT_OF_SYNCH);
            } else {
                response.setStatus(204);
                this.setPDPSummaryStatus(pdp, PDPStatus.Status.UP_TO_DATE);
            }
            this.notifyAC();
        }
        catch (PAPException e) {
            logger.debug((Object)("POST exception: " + (Object)((Object)e)), (Throwable)e);
            response.sendError(500, e.getMessage());
            return;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            XACMLRest.dumpRequest((HttpServletRequest)request);
            String groupId = request.getParameter("groupId");
            if (groupId != null) {
                this.doACGet(request, response, groupId);
                return;
            }
            String id = this.getPDPID(request);
            logger.info((Object)("doGet from: " + id));
            PDP pdp = this.papEngine.getPDP(id);
            if (pdp == null) {
                String message = "Unknown PDP: " + id + " from " + request.getRemoteHost() + " us: " + request.getLocalAddr();
                logger.info((Object)message);
                if (request.getRemoteHost().equals("localhost") || request.getRemoteHost().equals("127.0.0.1") || request.getRemoteHost().equals(request.getLocalAddr())) {
                    Set groups = this.papEngine.getPDPGroups();
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.writeValue((OutputStream)response.getOutputStream(), (Object)groups);
                    response.setHeader("content-type", "application/json");
                    response.setStatus(200);
                    return;
                }
                response.sendError(401, message);
                return;
            }
            PDPGroup group = this.papEngine.getPDPGroup(pdp);
            if (group == null) {
                String message = "No group associated with pdp " + pdp.getId();
                logger.warn((Object)message);
                response.sendError(401, message);
                return;
            }
            String policyId = request.getParameter("id");
            if (policyId == null) {
                String message = "Did not specify an id for the policy";
                logger.warn((Object)message);
                response.sendError(404, message);
                return;
            }
            PDPPolicy policy = group.getPolicy(policyId);
            if (policy == null) {
                String message = "Unknown policy: " + policyId;
                logger.warn((Object)message);
                response.sendError(404, message);
                return;
            }
            try (InputStream is = policy.getStream();
                 ServletOutputStream os = response.getOutputStream();){
                IOUtils.copy((InputStream)is, (OutputStream)os);
                response.setStatus(200);
            }
            catch (PAPException e) {
                String message = "Failed to open policy id " + policyId;
                logger.error((Object)message);
                response.sendError(404, message);
            }
        }
        catch (PAPException e) {
            logger.error((Object)("GET exception: " + (Object)((Object)e)), (Throwable)e);
            response.sendError(500, e.getMessage());
            return;
        }
    }

    protected String getPDPID(HttpServletRequest request) {
        String pdpURL = request.getHeader("X-XACML-PDP-ID");
        if (pdpURL == null || pdpURL.isEmpty()) {
            logger.warn((Object)"PDP did not send custom header");
            pdpURL = "";
        }
        return pdpURL;
    }

    private boolean isPDPCurrent(Properties policies, Properties pipconfig, Properties pdpProperties) {
        String localRootPolicies = policies.getProperty("xacml.rootPolicies");
        String localReferencedPolicies = policies.getProperty("xacml.referencedPolicies");
        if (localRootPolicies == null || localReferencedPolicies == null) {
            logger.warn((Object)("Missing property on PAP server: RootPolicies=" + localRootPolicies + "  ReferencedPolicies=" + localReferencedPolicies));
            return false;
        }
        try {
            Properties pdpPolicies = XACMLProperties.getPolicyProperties((Properties)pdpProperties, (boolean)false);
            Properties pdpPipConfig = XACMLProperties.getPipProperties((Properties)pdpProperties);
            if (localRootPolicies.equals(pdpPolicies.getProperty("xacml.rootPolicies")) && localReferencedPolicies.equals(pdpPolicies.getProperty("xacml.referencedPolicies")) && pdpPipConfig.equals(pipconfig)) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private void populatePolicyURL(StringBuffer urlPath, Properties policies) {
        String[] lists = new String[]{policies.getProperty("xacml.rootPolicies"), policies.getProperty("xacml.referencedPolicies")};
        for (String list : lists) {
            if (list == null || list.isEmpty()) continue;
            for (String id : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)list)) {
                String url = urlPath + "?id=" + id;
                logger.info((Object)("Policy URL for " + id + ": " + url));
                policies.setProperty(id + ".url", url);
            }
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XACMLRest.dumpRequest((HttpServletRequest)request);
        request.getInputStream();
        String acURLString = request.getParameter("adminConsoleURL");
        if (acURLString != null) {
            if (!adminConsoleURLStringList.contains(acURLString)) {
                adminConsoleURLStringList.add(acURLString);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Admin Console registering with URL: " + acURLString));
            }
            response.setStatus(204);
            return;
        }
        String groupId = request.getParameter("groupId");
        if (groupId != null) {
            this.doACPut(request, response, groupId);
            return;
        }
        response.sendError(400, "Request does not have groupId");
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XACMLRest.dumpRequest((HttpServletRequest)request);
        String groupId = request.getParameter("groupId");
        if (groupId != null) {
            this.doACDelete(request, response, groupId);
            return;
        }
        response.sendError(400, "Request does not have groupId");
    }

    private void doACGet(HttpServletRequest request, HttpServletResponse response, String groupId) throws ServletException, IOException {
        try {
            String parameterDefault = request.getParameter("default");
            String pdpId = request.getParameter("pdpId");
            String pdpGroup = request.getParameter("getPDPGroup");
            if ("".equals(groupId)) {
                if (parameterDefault != null) {
                    PDPGroup group = this.papEngine.getDefaultGroup();
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.writeValue((OutputStream)response.getOutputStream(), (Object)group);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("GET Default group req from '" + request.getRequestURL() + "'"));
                    }
                    response.setStatus(200);
                    response.setHeader("content-type", "application/json");
                    response.getOutputStream().close();
                    return;
                }
                if (pdpId != null) {
                    if (pdpGroup == null) {
                        PDP pdp = this.papEngine.getPDP(pdpId);
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.writeValue((OutputStream)response.getOutputStream(), (Object)pdp);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("GET pdp '" + pdpId + "' req from '" + request.getRequestURL() + "'"));
                        }
                        response.setStatus(200);
                        response.setHeader("content-type", "application/json");
                        response.getOutputStream().close();
                        return;
                    }
                    PDP pdp = this.papEngine.getPDP(pdpId);
                    PDPGroup group = this.papEngine.getPDPGroup(pdp);
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.writeValue((OutputStream)response.getOutputStream(), (Object)group);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("GET PDP '" + pdpId + "' Group req from '" + request.getRequestURL() + "'"));
                    }
                    response.setStatus(200);
                    response.setHeader("content-type", "application/json");
                    response.getOutputStream().close();
                    return;
                }
                Set groups = this.papEngine.getPDPGroups();
                ObjectMapper mapper = new ObjectMapper();
                mapper.writeValue((OutputStream)response.getOutputStream(), (Object)groups);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"GET All groups req");
                }
                response.setStatus(200);
                response.setHeader("content-type", "application/json");
                response.getOutputStream().close();
                return;
            }
            PDPGroup group = this.papEngine.getGroup(groupId);
            if (group == null) {
                logger.error((Object)("Unknown groupId '" + groupId + "'"));
                response.sendError(404, "Unknown groupId '" + groupId + "'");
                return;
            }
            String policyId = request.getParameter("policyId");
            if (policyId == null) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.writeValue((OutputStream)response.getOutputStream(), (Object)group);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("GET group '" + group.getId() + "' req from '" + request.getRequestURL() + "'"));
                }
                response.setStatus(200);
                response.setHeader("content-type", "application/json");
                response.getOutputStream().close();
                return;
            }
            response.sendError(400, "GET Policy not implemented");
            logger.error((Object)"UNIMPLEMENTED ");
            response.sendError(400, "UNIMPLEMENTED");
        }
        catch (PAPException e) {
            logger.error((Object)("AC Get exception: " + (Object)((Object)e)), (Throwable)e);
            response.sendError(500, e.getMessage());
            return;
        }
    }

    private void doACPost(HttpServletRequest request, HttpServletResponse response, String groupId) throws ServletException, IOException {
        try {
            String groupName = request.getParameter("groupName");
            String groupDescription = request.getParameter("groupDescription");
            if (groupName != null && groupDescription != null) {
                String unescapedName = URLDecoder.decode(groupName, "UTF-8");
                String unescapedDescription = URLDecoder.decode(groupDescription, "UTF-8");
                try {
                    this.papEngine.newGroup(unescapedName, unescapedDescription);
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to create new group: " + e.getLocalizedMessage()));
                    response.sendError(500, "Unable to create new group '" + groupId + "'");
                    return;
                }
                response.setStatus(204);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New Group '" + groupId + "' created"));
                }
                this.notifyAC();
                return;
            }
            PDPGroup group = this.papEngine.getGroup(groupId);
            if (group == null) {
                logger.error((Object)("Unknown groupId '" + groupId + "'"));
                response.sendError(404, "Unknown groupId '" + groupId + "'");
                return;
            }
            if (request.getParameter("policyId") != null) {
                String policyId = request.getParameter("policyId");
                try {
                    ((StdPDPGroup)group).copyPolicyToFile(policyId, (InputStream)request.getInputStream());
                }
                catch (Exception e) {
                    String message = "Policy '" + policyId + "' not copied to group '" + groupId + "': " + e;
                    logger.error((Object)message);
                    response.sendError(500, message);
                    return;
                }
                response.setStatus(204);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("policy '" + policyId + "' copied to directory for group '" + groupId + "'"));
                }
                return;
            }
            if (request.getParameter("default") != null) {
                try {
                    this.papEngine.SetDefaultGroup(group);
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to set group: " + e.getLocalizedMessage()));
                    response.sendError(500, "Unable to set group '" + groupId + "' to default");
                    return;
                }
                response.setStatus(204);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Group '" + groupId + "' set to be default"));
                }
                this.notifyAC();
                return;
            }
            if (request.getParameter("pdpId") != null) {
                String pdpId = request.getParameter("pdpId");
                PDP pdp = this.papEngine.getPDP(pdpId);
                PDPGroup originalGroup = this.papEngine.getPDPGroup(pdp);
                this.papEngine.movePDP(pdp, group);
                response.setStatus(204);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("PDP '" + pdp.getId() + "' moved to group '" + group.getId() + "' set to be default"));
                }
                ((StdPDPGroup)originalGroup).resetStatus();
                ((StdPDPGroup)group).resetStatus();
                this.notifyAC();
                this.pdpChanged(pdp);
                return;
            }
        }
        catch (PAPException e) {
            logger.error((Object)("AC POST exception: " + (Object)((Object)e)), (Throwable)e);
            response.sendError(500, e.getMessage());
            return;
        }
    }

    private void doACPut(HttpServletRequest request, HttpServletResponse response, String groupId) throws ServletException, IOException {
        try {
            PDPGroup group = this.papEngine.getGroup(groupId);
            if (group == null) {
                logger.error((Object)("Unknown groupId '" + groupId + "'"));
                response.sendError(404, "Unknown groupId '" + groupId + "'");
                return;
            }
            if (request.getParameter("policy") != null) {
                logger.error((Object)"PARTIALLY IMPLEMENTED!!!  ACTUAL CHANGES SHOULD BE MADE BY PAP SERVLET!!! ");
                response.setStatus(204);
                return;
            }
            if (request.getParameter("pdpId") != null) {
                String pdpId = request.getParameter("pdpId");
                String json = null;
                Scanner scanner = new Scanner((InputStream)request.getInputStream());
                scanner.useDelimiter("\\A");
                json = scanner.hasNext() ? scanner.next() : "";
                scanner.close();
                logger.info((Object)("JSON request from AC: " + json));
                ObjectMapper mapper = new ObjectMapper();
                Object objectFromJSON = mapper.readValue(json, StdPDP.class);
                if (pdpId == null || objectFromJSON == null || !(objectFromJSON instanceof StdPDP) || ((StdPDP)objectFromJSON).getId() == null || !((StdPDP)objectFromJSON).getId().equals(pdpId)) {
                    logger.error((Object)("PDP new/update had bad input. pdpId=" + pdpId + " objectFromJSON=" + objectFromJSON));
                    response.sendError(500, "Bad input, pdpid=" + pdpId + " object=" + objectFromJSON);
                }
                StdPDP pdp = (StdPDP)objectFromJSON;
                if (this.papEngine.getPDP(pdpId) == null) {
                    this.papEngine.newPDP(pdp.getId(), group, pdp.getName(), pdp.getDescription());
                } else {
                    this.papEngine.updatePDP((PDP)pdp);
                }
                response.setStatus(204);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("PDP '" + pdpId + "' created/updated"));
                }
                ((StdPDPGroup)group).resetStatus();
                this.notifyAC();
                this.pdpChanged((PDP)pdp);
                return;
            }
            if (request.getParameter("pipId") != null) {
                logger.error((Object)"UNIMPLEMENTED ");
                response.sendError(400, "UNIMPLEMENTED");
                return;
            }
            String json = null;
            Scanner scanner = new Scanner((InputStream)request.getInputStream());
            scanner.useDelimiter("\\A");
            json = scanner.hasNext() ? scanner.next() : "";
            scanner.close();
            logger.info((Object)("JSON request from AC: " + json));
            ObjectMapper mapper = new ObjectMapper();
            Object objectFromJSON = mapper.readValue(json, StdPDPGroup.class);
            if (objectFromJSON == null || !(objectFromJSON instanceof StdPDPGroup) || !((StdPDPGroup)objectFromJSON).getId().equals(group.getId())) {
                logger.error((Object)("Group update had bad input. id=" + group.getId() + " objectFromJSON=" + objectFromJSON));
                response.sendError(500, "Bad input, id=" + group.getId() + " object=" + objectFromJSON);
            }
            ((StdPDPGroup)objectFromJSON).setDirectory(((StdPDPGroup)group).getDirectory());
            this.papEngine.updateGroup((PDPGroup)((StdPDPGroup)objectFromJSON));
            response.setStatus(204);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Group '" + group.getId() + "' updated"));
            }
            this.notifyAC();
            this.groupChanged(group);
            return;
        }
        catch (PAPException e) {
            logger.error((Object)("AC PUT exception: " + (Object)((Object)e)), (Throwable)e);
            response.sendError(500, e.getMessage());
            return;
        }
    }

    private void doACDelete(HttpServletRequest request, HttpServletResponse response, String groupId) throws ServletException, IOException {
        try {
            PDPGroup group = this.papEngine.getGroup(groupId);
            if (group == null) {
                logger.error((Object)("Unknown groupId '" + groupId + "'"));
                response.sendError(404, "Unknown groupId '" + groupId + "'");
                return;
            }
            if (request.getParameter("policy") != null) {
                logger.error((Object)"UNIMPLEMENTED ");
                response.sendError(400, "UNIMPLEMENTED");
                return;
            }
            if (request.getParameter("pdpId") != null) {
                String pdpId = request.getParameter("pdpId");
                PDP pdp = this.papEngine.getPDP(pdpId);
                this.papEngine.removePDP(pdp);
                ((StdPDPGroup)group).resetStatus();
                response.setStatus(204);
                this.notifyAC();
                this.pdpChanged(pdp);
                return;
            }
            if (request.getParameter("pipId") != null) {
                logger.error((Object)"UNIMPLEMENTED ");
                response.sendError(400, "UNIMPLEMENTED");
                return;
            }
            String moveToGroupId = request.getParameter("movePDPsToGroupId");
            PDPGroup moveToGroup = null;
            if (moveToGroupId != null) {
                moveToGroup = this.papEngine.getGroup(moveToGroupId);
            }
            HashSet movedPDPs = new HashSet();
            movedPDPs.addAll(group.getPdps());
            this.papEngine.removeGroup(group, moveToGroup);
            response.setStatus(204);
            this.notifyAC();
            for (PDP pdp : movedPDPs) {
                this.pdpChanged(pdp);
            }
            return;
        }
        catch (PAPException e) {
            logger.error((Object)("AC DELETE exception: " + (Object)((Object)e)), (Throwable)e);
            response.sendError(500, e.getMessage());
            return;
        }
    }

    private void setPDPSummaryStatus(PDP pdp, PDPStatus.Status newStatus) throws PAPException {
        this.setPDPSummaryStatus(pdp, newStatus.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPDPSummaryStatus(PDP pdp, String newStatus) throws PAPException {
        PAPEngine pAPEngine = this.papEngine;
        synchronized (pAPEngine) {
            StdPDPStatus status = (StdPDPStatus)pdp.getStatus();
            status.setStatus(PDPStatus.Status.valueOf((String)newStatus));
            ((StdPDP)pdp).setStatus((PDPStatus)status);
            StdPDPGroup group = (StdPDPGroup)this.papEngine.getPDPGroup(pdp);
            if (group != null) {
                group.resetStatus();
            }
        }
    }

    public void changed() {
        Set groups;
        try {
            groups = this.papEngine.getPDPGroups();
        }
        catch (PAPException e) {
            logger.error((Object)("getPDPGroups failed: " + e.getLocalizedMessage()));
            throw new RuntimeException("Unable to get Groups: " + (Object)((Object)e));
        }
        for (PDPGroup group : groups) {
            this.groupChanged(group);
        }
    }

    public void groupChanged(PDPGroup group) {
        for (PDP pdp : group.getPdps()) {
            this.pdpChanged(pdp);
        }
    }

    public void pdpChanged(PDP pdp) {
        Thread t = new Thread(new UpdatePDPThread(pdp));
        t.start();
    }

    private void notifyAC() {
        Thread t = new Thread(new NotifyACThread());
        t.start();
    }

    private class NotifyACThread
    implements Runnable {
        private NotifyACThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<String> disconnectedACs = new ArrayList<String>();
            for (String acURL : adminConsoleURLStringList) {
                HttpURLConnection connection = null;
                try {
                    acURL = acURL + "?PAPNotification=true";
                    acURL = acURL + "&objectType=all&action=update";
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("creating url for id '" + acURL + "'"));
                    }
                    URL url = new URL(acURL);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("PUT");
                    connection.setRequestProperty("Content-Type", "text/x-java-properties");
                    connection.setInstanceFollowRedirects(false);
                    connection.connect();
                    if (connection.getResponseCode() == 204) {
                        logger.info((Object)"Success. We updated correctly.");
                        continue;
                    }
                    logger.warn((Object)("Failed: " + connection.getResponseCode() + "  message: " + connection.getResponseMessage()));
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to sync config AC '" + acURL + "': " + e), (Throwable)e);
                    disconnectedACs.add(acURL);
                }
                finally {
                    connection.disconnect();
                }
            }
            if (disconnectedACs.size() > 0) {
                adminConsoleURLStringList.removeAll(disconnectedACs);
            }
        }
    }

    private class UpdatePDPThread
    implements Runnable {
        private PDP pdp;

        public UpdatePDPThread(PDP pdp) {
            this.pdp = pdp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpURLConnection connection = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("creating url for id '" + this.pdp.getId() + "'"));
                }
                URL url = new URL(this.pdp.getId() + "?cache=all");
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("PUT");
                connection.setRequestProperty("Content-Type", "text/x-java-properties");
                connection.setInstanceFollowRedirects(true);
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    PDPGroup group = XACMLPapServlet.this.papEngine.getPDPGroup(this.pdp);
                    if (group == null) {
                        Properties policyProperties = new Properties();
                        policyProperties.put("xacml.rootPolicies", "");
                        policyProperties.put("xacml.referencedPolicies", "");
                        policyProperties.store(os, "");
                        Properties pipProps = new Properties();
                        pipProps.setProperty("xacml.pip.engines", "");
                        pipProps.store(os, "");
                    } else {
                        group.getPolicyProperties().store(os, "");
                        Properties policyLocations = new Properties();
                        for (PDPPolicy policy : group.getPolicies()) {
                            policyLocations.put(policy.getId() + ".url", papURL + "?id=" + policy.getId());
                        }
                        policyLocations.store(os, "");
                        group.getPipConfigProperties().store(os, "");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to send property file to " + this.pdp.getId()), (Throwable)e);
                    connection.disconnect();
                    XACMLPapServlet.this.notifyAC();
                    return;
                }
                connection.connect();
                if (connection.getResponseCode() == 204) {
                    logger.info((Object)"Success. We are configured correctly.");
                    XACMLPapServlet.this.setPDPSummaryStatus(this.pdp, PDPStatus.Status.UP_TO_DATE);
                } else if (connection.getResponseCode() == 200) {
                    logger.info((Object)"Success. PDP needs to update its configuration.");
                    XACMLPapServlet.this.setPDPSummaryStatus(this.pdp, PDPStatus.Status.OUT_OF_SYNCH);
                } else {
                    logger.warn((Object)("Failed: " + connection.getResponseCode() + "  message: " + connection.getResponseMessage()));
                    XACMLPapServlet.this.setPDPSummaryStatus(this.pdp, PDPStatus.Status.UNKNOWN);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to sync config with PDP '" + this.pdp.getId() + "': " + e), (Throwable)e);
                try {
                    XACMLPapServlet.this.setPDPSummaryStatus(this.pdp, PDPStatus.Status.UNKNOWN);
                }
                catch (PAPException e1) {
                    logger.error((Object)("Unable to set status of PDP '" + this.pdp.getId() + "' to UNKNOWN: " + e), (Throwable)e);
                }
            }
            finally {
                connection.disconnect();
                XACMLPapServlet.this.notifyAC();
            }
        }
    }

    private class Heartbeat
    implements Runnable {
        private PAPEngine papEngine;
        private Set<PDP> pdps = new HashSet<PDP>();
        private int heartbeatInterval;
        private int heartbeatTimeout;
        public volatile boolean isRunning = false;

        public synchronized boolean isRunning() {
            return this.isRunning;
        }

        public synchronized void terminate() {
            this.isRunning = false;
        }

        public Heartbeat(PAPEngine engine) {
            this.papEngine = engine;
            this.heartbeatInterval = Integer.parseInt(XACMLProperties.getProperty((String)"xacml.rest.pap.heartbeat.interval", (String)"10000"));
            this.heartbeatTimeout = Integer.parseInt(XACMLProperties.getProperty((String)"xacml.rest.pap.heartbeat.timeout", (String)"10000"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Heartbeat heartbeat = this;
            synchronized (heartbeat) {
                this.isRunning = true;
            }
            HashMap<String, URL> idToURLMap = new HashMap<String, URL>();
            try {
                while (this.isRunning()) {
                    Thread.sleep(this.heartbeatInterval);
                    this.pdps.clear();
                    PAPEngine pAPEngine = this.papEngine;
                    synchronized (pAPEngine) {
                        try {
                            for (PDPGroup g : this.papEngine.getPDPGroups()) {
                                for (PDP p : g.getPdps()) {
                                    this.pdps.add(p);
                                }
                            }
                        }
                        catch (PAPException e) {
                            logger.error((Object)("Heartbeat unable to read PDPs from PAPEngine: " + e.getMessage()), (Throwable)e);
                        }
                    }
                    if (!this.isRunning()) {
                        logger.info((Object)"isRunning is false, getting out of loop.");
                        break;
                    }
                    boolean changeSeen = false;
                    for (PDP pdp : this.pdps) {
                        if (!this.isRunning()) {
                            logger.info((Object)"isRunning is false, getting out of loop.");
                            break;
                        }
                        URL pdpURL = (URL)idToURLMap.get(pdp.getId());
                        if (pdpURL == null) {
                            String fullURLString = null;
                            try {
                                fullURLString = pdp.getId() + "?type=hb";
                                pdpURL = new URL(fullURLString);
                                idToURLMap.put(pdp.getId(), pdpURL);
                            }
                            catch (MalformedURLException e) {
                                logger.error((Object)("PDP id '" + fullURLString + "' is not a valid URL: " + e), (Throwable)e);
                                continue;
                            }
                        }
                        String newStatus = "";
                        HttpURLConnection connection = null;
                        try {
                            connection = (HttpURLConnection)pdpURL.openConnection();
                            connection.setRequestMethod("GET");
                            connection.setConnectTimeout(this.heartbeatTimeout);
                            connection.connect();
                            if (connection.getResponseCode() == 204) {
                                newStatus = connection.getHeaderField("X-XACML-PDP-HB");
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Heartbeat '" + pdp.getId() + "' status='" + newStatus + "'"));
                                }
                            } else {
                                newStatus = PDPStatus.Status.UNKNOWN.toString();
                                logger.error((Object)("Heartbeat connect response code " + connection.getResponseCode() + ": " + pdp.getId()));
                            }
                        }
                        catch (UnknownHostException e) {
                            newStatus = PDPStatus.Status.NO_SUCH_HOST.toString();
                            logger.error((Object)("Heartbeat '" + pdp.getId() + "' NO_SUCH_HOST"));
                        }
                        catch (SocketTimeoutException e) {
                            newStatus = PDPStatus.Status.CANNOT_CONNECT.toString();
                            logger.error((Object)("Heartbeat '" + pdp.getId() + "' connection timeout: " + e));
                        }
                        catch (ConnectException e) {
                            newStatus = PDPStatus.Status.CANNOT_CONNECT.toString();
                            logger.error((Object)("Heartbeat '" + pdp.getId() + "' cannot connect: " + e));
                        }
                        catch (Exception e) {
                            newStatus = PDPStatus.Status.UNKNOWN.toString();
                            logger.error((Object)("Heartbeat '" + pdp.getId() + "' connect exception: " + e), (Throwable)e);
                        }
                        finally {
                            connection.disconnect();
                        }
                        if (pdp.getStatus().getStatus().toString().equals(newStatus)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("previous status='" + pdp.getStatus().getStatus() + "'  new Status='" + newStatus + "'"));
                        }
                        try {
                            XACMLPapServlet.this.setPDPSummaryStatus(pdp, newStatus);
                        }
                        catch (PAPException e) {
                            logger.error((Object)("Unable to set state for PDP '" + pdp.getId() + "': " + (Object)((Object)e)), (Throwable)e);
                        }
                        changeSeen = true;
                    }
                    if (!this.isRunning()) {
                        logger.info((Object)"isRunning is false, getting out of loop.");
                        break;
                    }
                    if (!changeSeen) continue;
                    XACMLPapServlet.this.notifyAC();
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"Heartbeat interrupted.  Shutting down");
                this.terminate();
            }
        }
    }
}

