/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.rest.impl;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicyFinder;
import org.apache.openaz.xacml.pdp.policy.PolicyFinderFactory;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyDef;
import org.apache.openaz.xacml.pdp.std.StdPolicyFinder;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.XACMLProperties;

public class XACMLPdpPolicyFinderFactory
extends PolicyFinderFactory {
    public static final String PROP_FILE = ".file";
    public static final String PROP_URL = ".url";
    private static Log logger = LogFactory.getLog(XACMLPdpPolicyFinderFactory.class);
    private List<PolicyDef> rootPolicies;
    private List<PolicyDef> referencedPolicies;
    private boolean needsInit = true;
    private Properties properties = null;

    public XACMLPdpPolicyFinderFactory() {
        this.init();
    }

    public XACMLPdpPolicyFinderFactory(Properties properties) {
        this.properties = properties;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PolicyDef loadPolicyDef(String policyId) {
        String propLocation = null;
        propLocation = this.properties == null ? XACMLProperties.getProperty((String)(policyId + PROP_FILE)) : this.properties.getProperty(policyId + PROP_FILE);
        if (propLocation != null) {
            File fileLocation = new File(propLocation);
            if (!fileLocation.exists()) {
                logger.error((Object)("Policy file " + fileLocation.getAbsolutePath() + " does not exist."));
            } else if (!fileLocation.canRead()) {
                logger.error((Object)("Policy file " + fileLocation.getAbsolutePath() + " cannot be read."));
            } else {
                try {
                    logger.info((Object)("Loading policy file " + fileLocation));
                    PolicyDef policyDef = DOMPolicyDef.load((File)fileLocation);
                    if (policyDef != null) {
                        return policyDef;
                    }
                }
                catch (DOMStructureException ex) {
                    logger.error((Object)("Error loading policy file " + fileLocation.getAbsolutePath() + ": " + ex.getMessage()), (Throwable)ex);
                    return new Policy(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                }
            }
        }
        if ((propLocation = this.properties == null ? XACMLProperties.getProperty((String)(policyId + PROP_URL)) : this.properties.getProperty(policyId + PROP_URL)) != null) {
            InputStream is = null;
            try {
                URL url = new URL(propLocation);
                URLConnection urlConnection = url.openConnection();
                logger.info((Object)("Loading policy file " + url.toString()));
                is = urlConnection.getInputStream();
                PolicyDef policyDef = DOMPolicyDef.load((InputStream)is);
                if (policyDef != null) {
                    PolicyDef policyDef2 = policyDef;
                    return policyDef2;
                }
            }
            catch (MalformedURLException ex) {
                logger.error((Object)("Invalid URL " + propLocation + ": " + ex.getMessage()), (Throwable)ex);
            }
            catch (IOException ex) {
                logger.error((Object)("IOException opening URL " + propLocation + ": " + ex.getMessage()), (Throwable)ex);
            }
            catch (DOMStructureException ex) {
                logger.error((Object)("Invalid Policy " + propLocation + ": " + ex.getMessage()), (Throwable)ex);
                Policy policy = new Policy(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                return policy;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)("Exception closing InputStream for GET of url " + propLocation + " : " + e.getMessage() + "  (May be memory leak)"), (Throwable)e);
                    }
                }
            }
        }
        logger.error((Object)("No known location for Policy " + policyId));
        return null;
    }

    protected List<PolicyDef> getPolicyDefs(String propertyName) {
        String policyIds = XACMLProperties.getProperty((String)propertyName);
        if (policyIds == null || policyIds.length() == 0) {
            return null;
        }
        Iterable policyIdArray = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)policyIds);
        if (policyIdArray == null) {
            return null;
        }
        ArrayList<PolicyDef> listPolicyDefs = new ArrayList<PolicyDef>();
        for (String policyId : policyIdArray) {
            PolicyDef policyDef = this.loadPolicyDef(policyId);
            if (policyDef == null) continue;
            listPolicyDefs.add(policyDef);
        }
        return listPolicyDefs;
    }

    protected synchronized void init() {
        if (this.needsInit) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Initializing");
            }
            this.rootPolicies = this.getPolicyDefs("xacml.rootPolicies");
            this.referencedPolicies = this.getPolicyDefs("xacml.referencedPolicies");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Root Policies: " + this.rootPolicies));
                logger.debug((Object)("Referenced Policies: " + this.referencedPolicies));
            }
            this.needsInit = false;
        }
    }

    public PolicyFinder getPolicyFinder() throws FactoryException {
        return new StdPolicyFinder(this.rootPolicies, this.referencedPolicies);
    }

    public PolicyFinder getPolicyFinder(Properties properties) throws FactoryException {
        return new StdPolicyFinder(this.rootPolicies, this.referencedPolicies);
    }
}

