/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.rest;

import com.google.common.base.Splitter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.pap.PAPException;
import org.apache.openaz.xacml.api.pap.PDPPIPConfig;
import org.apache.openaz.xacml.api.pap.PDPPolicy;
import org.apache.openaz.xacml.api.pap.PDPStatus;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.api.pdp.PDPEngineFactory;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPFinderFactory;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyDef;
import org.apache.openaz.xacml.rest.XACMLRest;
import org.apache.openaz.xacml.std.pap.StdPDPPIPConfig;
import org.apache.openaz.xacml.std.pap.StdPDPPolicy;
import org.apache.openaz.xacml.std.pap.StdPDPStatus;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.XACMLProperties;

public class XACMLPdpLoader {
    private static final Log logger = LogFactory.getLog(XACMLPdpLoader.class);

    public static synchronized PDPEngine loadEngine(StdPDPStatus status, Properties policyProperties, Properties pipProperties) {
        Object error;
        InputStream is;
        logger.info((Object)("loadEngine: " + policyProperties + " " + pipProperties));
        try {
            if (policyProperties == null) {
                policyProperties = new Properties();
                is = Files.newInputStream(XACMLPdpLoader.getPDPPolicyCache(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    policyProperties.load(is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            XACMLPdpLoader.cachePolicies(policyProperties);
            XACMLPdpLoader.validatePolicies(policyProperties, status);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Status: " + status));
            }
        }
        catch (Exception e) {
            error = "Failed to load Policy Cache properties file: " + e.getMessage();
            logger.error(error, (Throwable)e);
            status.addLoadError((String)error);
            status.setStatus(PDPStatus.Status.LOAD_ERRORS);
        }
        try {
            if (pipProperties == null) {
                pipProperties = new Properties();
                is = Files.newInputStream(XACMLPdpLoader.getPIPConfig(), new OpenOption[0]);
                error = null;
                try {
                    pipProperties.load(is);
                }
                catch (Throwable throwable) {
                    error = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (error != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)error).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            XACMLPdpLoader.validatePipConfiguration(pipProperties, status);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Status: " + status));
            }
        }
        catch (Exception e) {
            error = "Failed to load/validate Pip Config properties file: " + e.getMessage();
            logger.error(error, (Throwable)e);
            status.addLoadError((String)error);
            status.setStatus(PDPStatus.Status.LOAD_ERRORS);
        }
        if (status.getStatus() == PDPStatus.Status.LOAD_ERRORS) {
            logger.error((Object)"there were load errors");
            return null;
        }
        XACMLRest.loadXacmlProperties((Properties)policyProperties, (Properties)pipProperties);
        try {
            logger.info((Object)XACMLProperties.getProperties().toString());
        }
        catch (IOException e) {
            logger.error((Object)"Failed to get XACML Properties", (Throwable)e);
        }
        PDPEngineFactory factory = null;
        PDPEngine engine = null;
        try {
            factory = PDPEngineFactory.newInstance();
            engine = factory.newEngine();
            logger.info((Object)"Loaded new PDP engine.");
            status.setStatus(PDPStatus.Status.UP_TO_DATE);
        }
        catch (FactoryException e) {
            String error2 = "Failed to create new PDP Engine";
            logger.error((Object)error2, (Throwable)e);
            status.addLoadError(error2);
        }
        return engine;
    }

    public static synchronized void validatePolicies(Properties properties, StdPDPStatus status) throws PAPException {
        Set rootPolicies = XACMLProperties.getRootPolicyIDs((Properties)properties);
        Set refPolicies = XACMLProperties.getReferencedPolicyIDs((Properties)properties);
        for (String id : rootPolicies) {
            XACMLPdpLoader.loadPolicy(properties, status, id, true);
        }
        status.addAllLoadedRootPolicies(status.getLoadedPolicies());
        for (String id : refPolicies) {
            XACMLPdpLoader.loadPolicy(properties, status, id, false);
        }
        logger.info((Object)("Loaded " + status.getLoadedPolicies().size() + " policies, failed to load " + status.getFailedPolicies().size() + " policies, " + status.getLoadedRootPolicies().size() + " root policies"));
        if (status.getLoadedRootPolicies().size() == 0) {
            logger.warn((Object)"NO ROOT POLICIES LOADED!!!  Cannot serve PEP Requests.");
            status.addLoadWarning("NO ROOT POLICIES LOADED!!!  Cannot serve PEP Requests.");
        }
    }

    public static synchronized void loadPolicy(Properties properties, StdPDPStatus status, String id, boolean isRoot) throws PAPException {
        PolicyDef policy = null;
        String location = null;
        URI locationURI = null;
        boolean isFile = false;
        try {
            location = properties.getProperty(id + ".file");
            if (location == null) {
                location = properties.getProperty(id + ".url");
                if (location != null) {
                    locationURI = URI.create(location);
                    URL url = locationURI.toURL();
                    URLConnection urlConnection = url.openConnection();
                    urlConnection.setRequestProperty("X-XACML-PDP-ID", XACMLProperties.getProperty((String)"xacml.rest.pdp.id"));
                    Path outFile = Paths.get(XACMLPdpLoader.getPDPConfig().toAbsolutePath().toString(), id);
                    try (FileOutputStream fos = new FileOutputStream(outFile.toFile());){
                        IOUtils.copy((InputStream)urlConnection.getInputStream(), (OutputStream)fos);
                    }
                    isFile = true;
                    var12_17 = null;
                    try (InputStream fis = Files.newInputStream(outFile, new OpenOption[0]);){
                        policy = DOMPolicyDef.load((InputStream)fis);
                    }
                    catch (Throwable throwable) {
                        var12_17 = throwable;
                        throw throwable;
                    }
                    properties.setProperty(id + ".file", outFile.toAbsolutePath().toString());
                }
            } else {
                isFile = true;
                locationURI = Paths.get(location, new String[0]).toUri();
                try (InputStream is = Files.newInputStream(Paths.get(location, new String[0]), new OpenOption[0]);){
                    policy = DOMPolicyDef.load((InputStream)is);
                }
            }
            if (policy != null) {
                status.addLoadedPolicy((PDPPolicy)new StdPDPPolicy(id, isRoot, locationURI, properties));
                logger.info((Object)("Loaded policy: " + policy.getIdentifier() + " version: " + policy.getVersion().stringValue()));
            } else {
                String error = "Failed to load policy " + location;
                logger.error((Object)error);
                status.setStatus(PDPStatus.Status.LOAD_ERRORS);
                status.addLoadError(error);
                status.addFailedPolicy((PDPPolicy)new StdPDPPolicy(id, isRoot));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to load policy '" + id + "' from location '" + location + "'"), (Throwable)e);
            status.setStatus(PDPStatus.Status.LOAD_ERRORS);
            status.addFailedPolicy((PDPPolicy)new StdPDPPolicy(id, isRoot));
            if (isFile) {
                try {
                    logger.error((Object)("Corrupted policy file, deleting: " + location));
                    Files.delete(Paths.get(location, new String[0]));
                }
                catch (IOException e1) {
                    logger.error((Object)e1);
                }
            }
            throw new PAPException("Failed to load policy '" + id + "' from location '" + location + "'");
        }
    }

    public static synchronized void validatePipConfiguration(Properties properties, StdPDPStatus status) throws PAPException {
        try {
            PIPFinderFactory factory = PIPFinderFactory.newInstance((Properties)properties);
            if (factory == null) {
                throw new FactoryException("Could not create PIP Finder Factory: " + properties.getProperty("xacml.pipFinderFactory"));
            }
            PIPFinder finder = factory.getFinder(properties);
            if (finder == null) {
                logger.error((Object)"pip finder factory returned a null engine.");
                throw new PIPException("Could not create PIP Finder");
            }
            logger.info((Object)"Loaded PIP finder");
            for (PIPEngine engine : finder.getPIPEngines()) {
                logger.info((Object)("Configured PIP Engine: " + engine.getName()));
                StdPDPPIPConfig config = new StdPDPPIPConfig();
                config.setName(engine.getName());
                status.addLoadedPipConfig((PDPPIPConfig)config);
            }
        }
        catch (PIPException | FactoryException e) {
            logger.error((Object)("validate PIP configuration failed: " + e.getLocalizedMessage()));
            status.addLoadError(e.getLocalizedMessage());
            status.setStatus(PDPStatus.Status.LOAD_ERRORS);
            throw new PAPException(e);
        }
    }

    public static synchronized boolean cachePolicies(Properties props) throws PAPException {
        boolean changed = false;
        String[] lists = new String[]{props.getProperty("xacml.rootPolicies"), props.getProperty("xacml.referencedPolicies")};
        for (String list : lists) {
            if (list == null || list.length() == 0) continue;
            Iterable policies = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)list);
            for (String policy : policies) {
                boolean policyExists = false;
                String propLocation = props.getProperty(policy + ".file");
                if (propLocation != null && !(policyExists = Files.exists(Paths.get(propLocation, new String[0]), new LinkOption[0]))) {
                    logger.warn((Object)("Policy file " + policy + " expected at " + propLocation + " does NOT exist."));
                }
                if (policyExists) continue;
                Path outFile = Paths.get(XACMLPdpLoader.getPDPConfig().toAbsolutePath().toString(), policy);
                policyExists = Files.exists(outFile, new LinkOption[0]);
                if (policyExists) {
                    logger.info((Object)("Policy does exist: " + outFile.toAbsolutePath().toString()));
                    props.setProperty(policy + ".file", outFile.toAbsolutePath().toString());
                    changed = true;
                    continue;
                }
                propLocation = props.getProperty(policy + ".url");
                if (propLocation != null) {
                    URL url = null;
                    try {
                        url = new URL(propLocation);
                        logger.info((Object)("Pulling " + url.toString()));
                        URLConnection urlConnection = url.openConnection();
                        urlConnection.setRequestProperty("X-XACML-PDP-ID", XACMLProperties.getProperty((String)"xacml.rest.pdp.id"));
                        try (InputStream is = urlConnection.getInputStream();
                             FileOutputStream os = new FileOutputStream(outFile.toFile());){
                            IOUtils.copy((InputStream)is, (OutputStream)os);
                        }
                        logger.info((Object)("Pulled policy: " + outFile.toAbsolutePath().toString()));
                        props.setProperty(policy + ".file", outFile.toAbsolutePath().toString());
                        changed = true;
                    }
                    catch (Exception e) {
                        if (e instanceof MalformedURLException) {
                            logger.error((Object)("Policy '" + policy + "' had bad URL in new configuration, URL='" + propLocation + "'"));
                            continue;
                        }
                        logger.error((Object)("Error while retrieving policy " + policy + " from URL " + url.toString() + ", e=" + e));
                    }
                    continue;
                }
                logger.error((Object)("Policy " + policy + " does NOT exist and does NOT have a URL"));
            }
        }
        return changed;
    }

    public static synchronized Path getPDPPolicyCache() throws PAPException {
        Path config = XACMLPdpLoader.getPDPConfig();
        Path policyProperties = Paths.get(config.toAbsolutePath().toString(), "xacml.policy.properties");
        if (Files.notExists(policyProperties, new LinkOption[0])) {
            logger.warn((Object)(policyProperties.toAbsolutePath().toString() + " does NOT exist."));
            try {
                Files.createFile(policyProperties, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to create policy properties file: " + policyProperties.toAbsolutePath().toString()));
                throw new PAPException("Failed to create policy properties file: " + policyProperties.toAbsolutePath().toString());
            }
        }
        return policyProperties;
    }

    public static synchronized Path getPIPConfig() throws PAPException {
        Path config = XACMLPdpLoader.getPDPConfig();
        Path pipConfigProperties = Paths.get(config.toAbsolutePath().toString(), "xacml.pip.properties");
        if (Files.notExists(pipConfigProperties, new LinkOption[0])) {
            logger.warn((Object)(pipConfigProperties.toAbsolutePath().toString() + " does NOT exist."));
            try {
                Files.createFile(pipConfigProperties, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to create pip properties file: " + pipConfigProperties.toAbsolutePath().toString()));
                throw new PAPException("Failed to create pip properties file: " + pipConfigProperties.toAbsolutePath().toString());
            }
        }
        return pipConfigProperties;
    }

    public static synchronized Path getPDPConfig() throws PAPException {
        Path config = Paths.get(XACMLProperties.getProperty((String)"xacml.rest.pdp.config"), new String[0]);
        if (Files.notExists(config, new LinkOption[0])) {
            logger.warn((Object)(config.toAbsolutePath().toString() + " does NOT exist."));
            try {
                Files.createDirectories(config, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to create config directory: " + config.toAbsolutePath().toString()), (Throwable)e);
                throw new PAPException("Failed to create config directory: " + config.toAbsolutePath().toString());
            }
        }
        return config;
    }
}

