/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.ContentType;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.pap.PDPStatus;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.api.pdp.PDPException;
import org.apache.openaz.xacml.rest.XACMLPdpLoader;
import org.apache.openaz.xacml.rest.XACMLPdpRegisterThread;
import org.apache.openaz.xacml.rest.XACMLRest;
import org.apache.openaz.xacml.std.dom.DOMRequest;
import org.apache.openaz.xacml.std.dom.DOMResponse;
import org.apache.openaz.xacml.std.json.JSONRequest;
import org.apache.openaz.xacml.std.json.JSONResponse;
import org.apache.openaz.xacml.std.pap.StdPDPStatus;
import org.apache.openaz.xacml.util.XACMLProperties;

@WebServlet(description="Implements the XACML PDP RESTful API and client PAP API.", urlPatterns={"/"}, loadOnStartup=1, initParams={@WebInitParam(name="XACML_PROPERTIES_NAME", value="xacml.pdp.properties", description="The location of the PDP xacml.pdp.properties file holding configuration information.")})
public class XACMLPdpServlet
extends HttpServlet
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(XACMLPdpServlet.class);
    private static final Log requestLogger = LogFactory.getLog((String)"xacml.request");
    private Thread registerThread = null;
    private XACMLPdpRegisterThread registerRunnable = null;
    private PDPEngine pdpEngine = null;
    private static final Object pdpEngineLock = new Object();
    private static volatile StdPDPStatus status = new StdPDPStatus();
    private static final Object pdpStatusLock = new Object();
    public static volatile BlockingQueue<PutRequest> queue = new LinkedBlockingQueue<PutRequest>(2);
    private Thread configThread = null;
    private volatile boolean configThreadTerminate = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        XACMLRest.xacmlInit((ServletConfig)config);
        PDPEngine engine = XACMLPdpLoader.loadEngine(status, null, null);
        if (engine != null) {
            Object object = pdpEngineLock;
            synchronized (object) {
                this.pdpEngine = engine;
            }
        }
        if (Boolean.parseBoolean(XACMLProperties.getProperty((String)"xacml.rest.pdp.register"))) {
            this.registerRunnable = new XACMLPdpRegisterThread();
            this.registerThread = new Thread(this.registerRunnable);
            this.registerThread.start();
        }
        this.configThread = new Thread(this);
        this.configThread.start();
    }

    public void destroy() {
        super.destroy();
        logger.info((Object)"Destroying....");
        if (this.registerRunnable != null) {
            try {
                this.registerRunnable.terminate();
                if (this.registerThread != null) {
                    this.registerThread.interrupt();
                    this.registerThread.join();
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
        this.configThreadTerminate = true;
        try {
            this.configThread.interrupt();
            this.configThread.join();
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        logger.info((Object)"Destroyed.");
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cache;
        if (logger.isDebugEnabled()) {
            XACMLRest.dumpRequest((HttpServletRequest)request);
        }
        if ((cache = request.getParameter("cache")) != null && request.getContentType().equals("text/x-java-properties")) {
            if (request.getContentLength() > Integer.parseInt(XACMLProperties.getProperty((String)"MAX_CONTENT_LENGTH", (String)"32767"))) {
                String message = "Content-Length larger than server will accept.";
                logger.info((Object)message);
                response.sendError(400, message);
                return;
            }
        } else {
            String message = "Invalid cache: '" + cache + "' or content-type: '" + request.getContentType() + "'";
            logger.error((Object)message);
            response.sendError(400, message);
            return;
        }
        this.doPutConfig(cache, request, response);
    }

    protected void doPutConfig(String config, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            try {
                if (queue.remainingCapacity() <= 0) {
                    logger.error((Object)"Queue capacity reached");
                    response.sendError(409, "Multiple configuration changes waiting processing.");
                    return;
                }
                Properties newProperties = new Properties();
                newProperties.load((InputStream)request.getInputStream());
                if (newProperties.size() == 0) {
                    logger.error((Object)"No properties in PUT");
                    response.sendError(400, "PUT must contain at least one property");
                    return;
                }
                if (config.equals("policies")) {
                    if ((newProperties = XACMLProperties.getPolicyProperties((Properties)newProperties, (boolean)true)).size() == 0) {
                        logger.error((Object)"No policy properties in PUT");
                        response.sendError(400, "PUT with cache=policies must contain at least one policy property");
                        return;
                    }
                    queue.offer(new PutRequest(newProperties, null));
                    break block11;
                }
                if (config.equals("pips")) {
                    if ((newProperties = XACMLProperties.getPipProperties((Properties)newProperties)).size() == 0) {
                        logger.error((Object)"No pips properties in PUT");
                        response.sendError(400, "PUT with cache=pips must contain at least one pip property");
                        return;
                    }
                    queue.offer(new PutRequest(null, newProperties));
                    break block11;
                }
                if (config.equals("all")) {
                    Properties newPolicyProperties = XACMLProperties.getPolicyProperties((Properties)newProperties, (boolean)true);
                    if (newPolicyProperties.size() == 0) {
                        logger.error((Object)"No policy properties in PUT");
                        response.sendError(400, "PUT with cache=all must contain at least one policy property");
                        return;
                    }
                    Properties newPipProperties = XACMLProperties.getPipProperties((Properties)newProperties);
                    if (newPipProperties.size() == 0) {
                        logger.error((Object)"No pips properties in PUT");
                        response.sendError(400, "PUT with cache=all must contain at least one pip property");
                        return;
                    }
                    queue.offer(new PutRequest(newPolicyProperties, newPipProperties));
                    break block11;
                }
                logger.error((Object)("Invalid config value: " + config));
                response.sendError(400, "Config must be one of 'policies', 'pips', 'all'");
                return;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to process new configuration.", (Throwable)e);
                response.sendError(500, e.getMessage());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object object;
        XACMLRest.dumpRequest((HttpServletRequest)request);
        boolean returnHB = false;
        response.setHeader("Cache-Control", "no-cache");
        String type = request.getParameter("type");
        if ("config".equals(type)) {
            response.setContentType("text/x-java-properties");
            try {
                String lists = "xacml.rootPolicies=" + XACMLProperties.getProperty((String)"xacml.rootPolicies", (String)"");
                lists = lists + "\n" + "xacml.referencedPolicies" + "=" + XACMLProperties.getProperty((String)"xacml.referencedPolicies", (String)"") + "\n";
                try (ByteArrayInputStream listInputStream = new ByteArrayInputStream(lists.getBytes());
                     InputStream pipInputStream = Files.newInputStream(XACMLPdpLoader.getPIPConfig(), new OpenOption[0]);
                     ServletOutputStream os = response.getOutputStream();){
                    IOUtils.copy((InputStream)listInputStream, (OutputStream)os);
                    IOUtils.copy((InputStream)pipInputStream, (OutputStream)os);
                }
                response.setStatus(200);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to copy property file", (Throwable)e);
                response.sendError(400, "Failed to copy Property file");
            }
        } else if ("hb".equals(type)) {
            returnHB = true;
            response.setStatus(204);
        } else if ("Status".equals(type)) {
            object = pdpStatusLock;
            synchronized (object) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.writeValue((OutputStream)response.getOutputStream(), (Object)status);
            }
            response.setStatus(200);
        } else {
            response.sendError(400, "type not 'config' or 'hb'");
        }
        if (returnHB) {
            object = pdpStatusLock;
            synchronized (object) {
                response.addHeader("X-XACML-PDP-HB", status.getStatus().toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String message;
        Request pdpRequest;
        String incomingRequestString;
        ContentType contentType;
        block42: {
            if (status.getLoadedRootPolicies().size() == 0) {
                logger.warn((Object)("Request from PEP at " + request.getRequestURI() + " for service when PDP has No Root Policies loaded"));
                response.sendError(503);
                return;
            }
            XACMLRest.dumpRequest((HttpServletRequest)request);
            response.setHeader("Cache-Control", "no-cache");
            if (request.getContentType() == null) {
                logger.warn((Object)"Must specify a Content-Type");
                response.sendError(400, "no content-type given");
                return;
            }
            if (request.getContentLength() > Integer.parseInt(XACMLProperties.getProperty((String)"MAX_CONTENT_LENGTH", (String)"32767"))) {
                String message2 = "Content-Length larger than server will accept.";
                logger.info((Object)message2);
                response.sendError(400, message2);
                return;
            }
            if (request.getContentLength() <= 0) {
                String message3 = "Content-Length is negative";
                logger.info((Object)message3);
                response.sendError(400, message3);
                return;
            }
            contentType = null;
            try {
                contentType = ContentType.parse((String)request.getContentType());
            }
            catch (Exception e) {
                String message4 = "Parsing Content-Type: " + request.getContentType() + ", error=" + e.getMessage();
                logger.error((Object)message4, (Throwable)e);
                response.sendError(400, message4);
                return;
            }
            incomingRequestString = null;
            pdpRequest = null;
            if (!(contentType.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_JSON.getMimeType()) || contentType.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_XML.getMimeType()) || contentType.getMimeType().equalsIgnoreCase("application/xacml+xml"))) {
                String message5 = "unsupported content type" + request.getContentType();
                logger.error((Object)message5);
                response.sendError(400, message5);
                return;
            }
            StringBuilder buffer = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                }
                incomingRequestString = buffer.toString();
            }
            logger.info((Object)incomingRequestString);
            try {
                if (contentType.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_JSON.getMimeType())) {
                    pdpRequest = JSONRequest.load((String)incomingRequestString);
                    break block42;
                }
                if (contentType.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_XML.getMimeType()) || contentType.getMimeType().equalsIgnoreCase("application/xacml+xml")) {
                    pdpRequest = DOMRequest.load((String)incomingRequestString);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not parse request", (Throwable)e);
                response.sendError(400, e.getMessage());
                return;
            }
        }
        if (pdpRequest == null || pdpRequest.getRequestAttributes() == null || pdpRequest.getRequestAttributes().size() <= 0) {
            String message6 = "Zero Attributes found in the request";
            logger.error((Object)message6);
            response.sendError(400, message6);
            return;
        }
        try {
            long lTimeEnd;
            long lTimeStart;
            PDPEngine myEngine = null;
            Object e = pdpEngineLock;
            // MONITORENTER : e
            myEngine = this.pdpEngine;
            // MONITOREXIT : e
            if (myEngine == null) {
                message = "No engine loaded.";
                logger.error((Object)message);
                response.sendError(500, message);
                return;
            }
            Response pdpResponse = null;
            Object object = pdpEngineLock;
            // MONITORENTER : object
            myEngine = this.pdpEngine;
            try {
                lTimeStart = System.currentTimeMillis();
                pdpResponse = myEngine.decide(pdpRequest);
                lTimeEnd = System.currentTimeMillis();
            }
            catch (PDPException e2) {
                String message7 = "Exception during decide: " + e2.getMessage();
                logger.error((Object)message7);
                response.sendError(500, message7);
                // MONITOREXIT : object
                return;
            }
            requestLogger.info((Object)(lTimeStart + "=" + incomingRequestString));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request time: " + (lTimeEnd - lTimeStart) + "ms"));
            }
            if (pdpResponse == null) {
                requestLogger.info((Object)(lTimeStart + "=" + "{}"));
                throw new Exception("Failed to get response from PDP engine.");
            }
            response.setContentType(contentType.getMimeType());
            String outgoingResponseString = "";
            if (contentType.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_JSON.getMimeType())) {
                outgoingResponseString = JSONResponse.toString((Response)pdpResponse, (boolean)logger.isDebugEnabled());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)outgoingResponseString);
                    outgoingResponseString = JSONResponse.toString((Response)pdpResponse, (boolean)false);
                }
            } else if (contentType.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_XML.getMimeType()) || contentType.getMimeType().equalsIgnoreCase("application/xacml+xml")) {
                outgoingResponseString = DOMResponse.toString((Response)pdpResponse, (boolean)logger.isDebugEnabled());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)outgoingResponseString);
                    outgoingResponseString = DOMResponse.toString((Response)pdpResponse, (boolean)false);
                }
            }
            requestLogger.info((Object)(lTimeStart + "=" + outgoingResponseString));
            response.getWriter().print(outgoingResponseString);
        }
        catch (Exception e) {
            message = "Exception executing request: " + e;
            logger.error((Object)message, (Throwable)e);
            response.sendError(500, message);
            return;
        }
        response.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this.configThreadTerminate) {
                PutRequest request = queue.take();
                StdPDPStatus newStatus = new StdPDPStatus();
                PDPEngine newEngine = null;
                Object object = pdpStatusLock;
                // MONITORENTER : object
                status.setStatus(PDPStatus.Status.UPDATING_CONFIGURATION);
                newEngine = XACMLPdpLoader.loadEngine(newStatus, request.policyProperties, request.pipConfigProperties);
                // MONITOREXIT : object
                if (newEngine != null) {
                    object = pdpEngineLock;
                    // MONITORENTER : object
                    this.pdpEngine = newEngine;
                    try {
                        Throwable throwable;
                        OutputStream os;
                        logger.info((Object)"Saving configuration.");
                        if (request.policyProperties != null) {
                            os = Files.newOutputStream(XACMLPdpLoader.getPDPPolicyCache(), new OpenOption[0]);
                            throwable = null;
                            try {
                                request.policyProperties.store(os, "");
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (os != null) {
                                    if (throwable != null) {
                                        try {
                                            os.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        os.close();
                                    }
                                }
                            }
                        }
                        if (request.pipConfigProperties != null) {
                            os = Files.newOutputStream(XACMLPdpLoader.getPIPConfig(), new OpenOption[0]);
                            throwable = null;
                            try {
                                request.pipConfigProperties.store(os, "");
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (os != null) {
                                    if (throwable != null) {
                                        try {
                                            os.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        os.close();
                                    }
                                }
                            }
                        }
                        newStatus.setStatus(PDPStatus.Status.UP_TO_DATE);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to store new properties.");
                        newStatus.setStatus(PDPStatus.Status.LOAD_ERRORS);
                        newStatus.addLoadWarning("Unable to save configuration: " + e.getMessage());
                    }
                } else {
                    newStatus.setStatus(PDPStatus.Status.LAST_UPDATE_FAILED);
                }
                object = pdpStatusLock;
                // MONITORENTER : object
                status.set(newStatus);
                // MONITOREXIT : object
            }
            return;
        }
        catch (InterruptedException e) {
            logger.error((Object)"interrupted");
        }
    }

    public static class PutRequest {
        public Properties policyProperties = null;
        public Properties pipConfigProperties = null;

        PutRequest(Properties policies, Properties pips) {
            this.policyProperties = policies;
            this.pipConfigProperties = pips;
        }
    }
}

