/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.rest.XACMLPdpLoader;
import org.apache.openaz.xacml.rest.XACMLPdpServlet;
import org.apache.openaz.xacml.util.XACMLProperties;

public class XACMLPdpRegisterThread
implements Runnable {
    private static final Log logger = LogFactory.getLog(XACMLPdpRegisterThread.class);
    public volatile boolean isRunning = false;

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void terminate() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int retries;
        int seconds;
        XACMLPdpRegisterThread xACMLPdpRegisterThread = this;
        synchronized (xACMLPdpRegisterThread) {
            this.isRunning = true;
        }
        boolean registered = false;
        boolean interrupted = false;
        try {
            seconds = Integer.parseInt(XACMLProperties.getProperty((String)"xacml.rest.pdp.register.sleep"));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"REGISTER_SLEEP: ", (Throwable)e);
            seconds = 5;
        }
        if (seconds < 5) {
            seconds = 5;
        }
        try {
            retries = Integer.parseInt(XACMLProperties.getProperty((String)"xacml.rest.pdp.register.retries"));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"REGISTER_SLEEP: ", (Throwable)e);
            retries = -1;
        }
        while (!registered && !interrupted && this.isRunning()) {
            URLConnection connection = null;
            try {
                URL url = new URL(XACMLProperties.getProperty((String)"xacml.rest.pap.url"));
                logger.info((Object)("Registering with " + url.toString()));
                boolean finished = false;
                while (!finished) {
                    connection = (HttpURLConnection)url.openConnection();
                    ((HttpURLConnection)connection).setRequestMethod("POST");
                    connection.setRequestProperty("Accept", "text/x-java-properties");
                    connection.setRequestProperty("Content-Type", "text/x-java-properties");
                    connection.setRequestProperty("X-XACML-PDP-ID", XACMLProperties.getProperty((String)"xacml.rest.pdp.id"));
                    connection.setUseCaches(false);
                    ((HttpURLConnection)connection).setInstanceFollowRedirects(false);
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    try {
                        String lists = "xacml.rootPolicies=" + XACMLProperties.getProperty((String)"xacml.rootPolicies");
                        lists = lists + "\n" + "xacml.referencedPolicies" + "=" + XACMLProperties.getProperty((String)"xacml.referencedPolicies") + "\n";
                        try (ByteArrayInputStream listsInputStream = new ByteArrayInputStream(lists.getBytes());
                             InputStream pipInputStream = Files.newInputStream(XACMLPdpLoader.getPIPConfig(), new OpenOption[0]);
                             OutputStream os = connection.getOutputStream();){
                            IOUtils.copy((InputStream)listsInputStream, (OutputStream)os);
                            IOUtils.copy((InputStream)pipInputStream, (OutputStream)os);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to send property file", (Throwable)e);
                    }
                    connection.connect();
                    if (((HttpURLConnection)connection).getResponseCode() == 204) {
                        logger.info((Object)"Success. We are configured correctly.");
                        finished = true;
                        registered = true;
                        continue;
                    }
                    if (((HttpURLConnection)connection).getResponseCode() == 200) {
                        logger.info((Object)"Success. We have a new configuration.");
                        Properties properties = new Properties();
                        properties.load(connection.getInputStream());
                        logger.info((Object)("New properties: " + properties.toString()));
                        XACMLPdpServlet.PutRequest req = new XACMLPdpServlet.PutRequest(XACMLProperties.getPolicyProperties((Properties)properties, (boolean)false), XACMLProperties.getPipProperties((Properties)properties));
                        XACMLPdpServlet.queue.offer(req);
                        finished = true;
                        registered = true;
                        continue;
                    }
                    if (((HttpURLConnection)connection).getResponseCode() >= 300 && ((HttpURLConnection)connection).getResponseCode() <= 399) {
                        String newLocation = connection.getHeaderField("Location");
                        if (newLocation == null || newLocation.isEmpty()) {
                            logger.warn((Object)"Did not receive a valid re-direction location");
                            finished = true;
                            continue;
                        }
                        logger.info((Object)("New Location: " + newLocation));
                        url = new URL(newLocation);
                        continue;
                    }
                    logger.warn((Object)("Failed: " + ((HttpURLConnection)connection).getResponseCode() + "  message: " + ((HttpURLConnection)connection).getResponseMessage()));
                    finished = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                if (connection != null) {
                    try {
                        InputStream is = null;
                        try {
                            is = connection.getInputStream();
                        }
                        catch (Exception e1) {}
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ex) {
                        logger.error((Object)("Failed to close connection: " + ex), (Throwable)ex);
                    }
                    ((HttpURLConnection)connection).disconnect();
                }
            }
            try {
                if (registered) continue;
                if (retries > 0) {
                    --retries;
                } else if (retries == 0) break;
                Thread.sleep(seconds * 1000);
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.terminate();
            }
        }
        XACMLPdpRegisterThread xACMLPdpRegisterThread2 = this;
        synchronized (xACMLPdpRegisterThread2) {
            this.isRunning = false;
        }
        logger.info((Object)("Thread exiting...(registered=" + registered + ", interrupted=" + interrupted + ", isRunning=" + this.isRunning() + ", retries=" + retries + ")"));
    }
}

