/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.Iterator;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.std.StdStatus;

public abstract class ExpressionResult
implements FunctionArgument {
    private Status status;

    protected ExpressionResult(Status statusIn) {
        this.status = statusIn;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public boolean isOk() {
        return this.getStatus() == null || this.getStatus().isOk();
    }

    @Override
    public abstract AttributeValue<?> getValue();

    @Override
    public abstract boolean isBag();

    @Override
    public abstract Bag getBag();

    public String toString() {
        AttributeValue<?> value;
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("isOk=" + this.isOk());
        stringBuilder.append(", isBag=" + this.isBag());
        Status thisStatus = this.getStatus();
        if (thisStatus != null) {
            stringBuilder.append(", status=");
            stringBuilder.append(thisStatus.toString());
        }
        if ((value = this.getValue()) != null) {
            stringBuilder.append(", value=");
            stringBuilder.append(value);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static ExpressionResult newError(Status statusIn) {
        return new ExpressionResultError(statusIn);
    }

    public static ExpressionResult newSingle(AttributeValue<?> attributeValue) {
        return new ExpressionResultSingle(attributeValue);
    }

    public static ExpressionResult newBag(Bag bag) {
        return new ExpressionResultBag(bag);
    }

    public static ExpressionResult newEmpty() {
        return new ExpressionResultEmptyBag();
    }

    public static ExpressionResult newInstance(Status statusIn) {
        if (statusIn.getStatusCode().equals((Object)StdStatus.STATUS_OK.getStatusCode())) {
            return ExpressionResult.newEmpty();
        }
        return ExpressionResult.newError(statusIn);
    }

    private static class ExpressionResultEmptyBag
    extends ExpressionResult {
        public ExpressionResultEmptyBag() {
            super(StdStatus.STATUS_OK);
        }

        @Override
        public AttributeValue<?> getValue() {
            return null;
        }

        @Override
        public boolean isBag() {
            return true;
        }

        @Override
        public Bag getBag() {
            return Bag.EMPTY;
        }
    }

    private static class ExpressionResultBag
    extends ExpressionResult {
        private Bag bag;

        public ExpressionResultBag(Bag bagIn) {
            super(StdStatus.STATUS_OK);
            this.bag = bagIn;
        }

        @Override
        public AttributeValue<?> getValue() {
            Iterator<AttributeValue<?>> iter = this.bag.getAttributeValues();
            if (iter != null && iter.hasNext()) {
                return iter.next();
            }
            return null;
        }

        @Override
        public boolean isBag() {
            return true;
        }

        @Override
        public Bag getBag() {
            return this.bag;
        }
    }

    private static class ExpressionResultSingle
    extends ExpressionResult {
        AttributeValue<?> attributeValue;

        public ExpressionResultSingle(AttributeValue<?> attributeValueIn) {
            super(StdStatus.STATUS_OK);
            this.attributeValue = attributeValueIn;
        }

        @Override
        public AttributeValue<?> getValue() {
            return this.attributeValue;
        }

        @Override
        public boolean isBag() {
            return false;
        }

        @Override
        public Bag getBag() {
            return null;
        }
    }

    private static class ExpressionResultError
    extends ExpressionResult {
        public ExpressionResultError(Status statusIn) {
            super(statusIn);
        }

        @Override
        public AttributeValue<?> getValue() {
            return null;
        }

        @Override
        public boolean isBag() {
            return false;
        }

        @Override
        public Bag getBag() {
            return null;
        }
    }
}

