/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.dom.DOMExpression;
import org.apache.openaz.xacml.pdp.policy.expressions.Apply;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMApply
extends Apply {
    private static final Log logger = LogFactory.getLog(DOMApply.class);

    protected DOMApply() {
    }

    public static Apply newInstance(Node nodeApply, Policy policy) throws DOMStructureException {
        DOMApply domApply;
        block6: {
            Element elementApply = DOMUtil.getElement((Node)nodeApply);
            boolean bLenient = DOMProperties.isLenient();
            domApply = new DOMApply();
            try {
                NodeList children = nodeApply.getChildNodes();
                if (children != null) {
                    int numChildren = children.getLength();
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (child.getNodeType() != 1 || !"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(child.getNamespaceURI())) continue;
                        String childName = child.getLocalName();
                        if ("Description".equals(childName)) {
                            domApply.setDescription(child.getTextContent());
                            continue;
                        }
                        if (DOMExpression.isExpression(child)) {
                            domApply.addArgument(DOMExpression.newInstance(child, policy));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeApply);
                    }
                }
                domApply.setFunctionId(DOMUtil.getIdentifierAttribute((Node)elementApply, (String)"FunctionId", (!bLenient ? 1 : 0) != 0));
            }
            catch (DOMStructureException ex) {
                domApply.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block6;
                throw ex;
            }
        }
        return domApply;
    }

    public static boolean repair(Node nodeApply) throws DOMStructureException {
        Element elementApply = DOMUtil.getElement((Node)nodeApply);
        boolean result = false;
        NodeList children = nodeApply.getChildNodes();
        if (children != null) {
            int numChildren = children.getLength();
            for (int i = 0; i < numChildren; ++i) {
                String childName;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17".equals(child.getNamespaceURI()) || "Description".equals(childName = child.getLocalName())) continue;
                if (DOMExpression.isExpression(child)) {
                    result = DOMExpression.repair(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementApply.removeChild(child);
                result = true;
            }
        }
        result = DOMUtil.repairIdentifierAttribute((Element)elementApply, (String)"FunctionId", (Identifier)XACML3.ID_FUNCTION_STRING_EQUAL, (Log)logger) || result;
        return result;
    }
}

