/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithm;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithmFactory;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAdviceExpression;
import org.apache.openaz.xacml.pdp.policy.dom.DOMCombinerParameter;
import org.apache.openaz.xacml.pdp.policy.dom.DOMObligationExpression;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyIssuer;
import org.apache.openaz.xacml.pdp.policy.dom.DOMRule;
import org.apache.openaz.xacml.pdp.policy.dom.DOMRuleCombinerParameters;
import org.apache.openaz.xacml.pdp.policy.dom.DOMTarget;
import org.apache.openaz.xacml.pdp.policy.dom.DOMVariableDefinition;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPolicy {
    private static final Log logger = LogFactory.getLog(DOMPolicy.class);

    protected DOMPolicy() {
    }

    public static Policy newInstance(Node nodePolicy, PolicySet policySetParent, PolicyDefaults policyDefaultsParent) throws DOMStructureException {
        Policy domPolicy;
        block26: {
            Element elementPolicy = DOMUtil.getElement((Node)nodePolicy);
            boolean bLenient = DOMProperties.isLenient();
            domPolicy = new Policy(policySetParent);
            try {
                CombiningAlgorithm<Rule> combiningAlgorithmRule;
                Identifier identifier;
                block25: {
                    int numChildren;
                    NodeList children = elementPolicy.getChildNodes();
                    if (children != null && (numChildren = children.getLength()) > 0) {
                        Node child;
                        int i;
                        for (i = 0; i < numChildren; ++i) {
                            child = children.item(i);
                            if (!DOMUtil.isNamespaceElement((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") || !"PolicyDefaults".equals(child.getLocalName())) continue;
                            if (domPolicy.getPolicyDefaults() != null && !bLenient) {
                                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicy);
                            }
                            domPolicy.setPolicyDefaults(DOMPolicyDefaults.newInstance(child, policyDefaultsParent));
                        }
                        if (domPolicy.getPolicyDefaults() == null) {
                            domPolicy.setPolicyDefaults(policyDefaultsParent);
                        }
                        for (i = 0; i < numChildren; ++i) {
                            Iterator<PolicyComponent> iterator;
                            child = children.item(i);
                            if (!DOMUtil.isElement((Node)child) || !DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) continue;
                            String childName = child.getLocalName();
                            if ("Description".equals(childName)) {
                                if (domPolicy.getDescription() != null && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicy);
                                }
                                domPolicy.setDescription(child.getTextContent());
                                continue;
                            }
                            if ("PolicyIssuer".equals(childName)) {
                                if (domPolicy.getPolicyIssuer() != null && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicy);
                                }
                                domPolicy.setPolicyIssuer(DOMPolicyIssuer.newInstance(child));
                                continue;
                            }
                            if ("PolicyDefaults".equals(childName)) continue;
                            if ("Target".equals(childName)) {
                                if (domPolicy.getTarget() != null && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicy);
                                }
                                domPolicy.setTarget(DOMTarget.newInstance(child));
                                continue;
                            }
                            if ("CombinerParameters".equals(childName)) {
                                domPolicy.addCombinerParameters(DOMCombinerParameter.newList(child));
                                continue;
                            }
                            if ("RuleCombinerParameters".equals(childName)) {
                                domPolicy.addRuleCombinerParameter(DOMRuleCombinerParameters.newInstance(child));
                                continue;
                            }
                            if ("VariableDefinition".equals(childName)) {
                                domPolicy.addVariableDefinition(DOMVariableDefinition.newInstance(child, domPolicy));
                                continue;
                            }
                            if ("Rule".equals(childName)) {
                                domPolicy.addRule(DOMRule.newInstance(child, domPolicy));
                                continue;
                            }
                            if ("ObligationExpressions".equals(childName)) {
                                iterator = domPolicy.getObligationExpressions();
                                if (iterator != null && iterator.hasNext() && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicy);
                                }
                                domPolicy.setObligationExpressions(DOMObligationExpression.newList(child, domPolicy));
                                continue;
                            }
                            if ("AdviceExpressions".equals(childName)) {
                                iterator = domPolicy.getAdviceExpressions();
                                if (iterator != null && iterator.hasNext() && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicy);
                                }
                                domPolicy.setAdviceExpressions(DOMAdviceExpression.newList(child, domPolicy));
                                continue;
                            }
                            if (bLenient) continue;
                            throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicy);
                        }
                    }
                    domPolicy.setIdentifier(DOMUtil.getIdentifierAttribute((Node)elementPolicy, (String)"PolicyId", (!bLenient ? 1 : 0) != 0));
                    domPolicy.setVersion(DOMUtil.getVersionAttribute((Node)elementPolicy, (String)"Version", (!bLenient ? 1 : 0) != 0));
                    identifier = DOMUtil.getIdentifierAttribute((Node)elementPolicy, (String)"RuleCombiningAlgId", (!bLenient ? 1 : 0) != 0);
                    combiningAlgorithmRule = null;
                    try {
                        combiningAlgorithmRule = CombiningAlgorithmFactory.newInstance().getRuleCombiningAlgorithm(identifier);
                    }
                    catch (FactoryException ex) {
                        if (bLenient) break block25;
                        throw new DOMStructureException("Failed to get CombiningAlgorithm", (Throwable)ex);
                    }
                }
                if (combiningAlgorithmRule == null && !bLenient) {
                    throw new DOMStructureException((Node)elementPolicy, "Unknown rule combining algorithm \"" + identifier.toString() + "\" in \"" + DOMUtil.getNodeLabel((Node)nodePolicy));
                }
                domPolicy.setRuleCombiningAlgorithm(combiningAlgorithmRule);
                Integer integer = DOMUtil.getIntegerAttribute((Node)elementPolicy, (String)"MaxDelegationDepth");
                if (integer != null) {
                    domPolicy.setMaxDelegationDepth(integer);
                }
            }
            catch (DOMStructureException ex) {
                domPolicy.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block26;
                throw ex;
            }
        }
        return domPolicy;
    }

    public static boolean repair(Node nodePolicy) throws DOMStructureException {
        int numChildren;
        Element elementPolicy = DOMUtil.getElement((Node)nodePolicy);
        boolean result = false;
        NodeList children = elementPolicy.getChildNodes();
        boolean sawDescription = false;
        boolean sawIssuer = false;
        boolean sawTarget = false;
        boolean sawPolicyDefaults = false;
        boolean sawObligationExprs = false;
        boolean sawAdviceExprs = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child) || !DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) continue;
                String childName = child.getLocalName();
                if ("Description".equals(childName)) {
                    if (sawDescription) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicy.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawDescription = true;
                    continue;
                }
                if ("PolicyIssuer".equals(childName)) {
                    if (sawIssuer) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicy.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawDescription = true;
                    result = DOMPolicyIssuer.repair(child) || result;
                    continue;
                }
                if ("PolicyDefaults".equals(childName)) {
                    if (sawPolicyDefaults) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicy.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawPolicyDefaults = true;
                    result = DOMPolicyDefaults.repair(child) || result;
                    continue;
                }
                if ("Target".equals(childName)) {
                    if (sawTarget) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicy.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawTarget = true;
                    result = DOMTarget.repair(child) || result;
                    continue;
                }
                if ("CombinerParameters".equals(childName)) {
                    result = DOMCombinerParameter.repair(child) || result;
                    continue;
                }
                if ("RuleCombinerParameters".equals(childName)) {
                    result = DOMRuleCombinerParameters.repair(child) || result;
                    continue;
                }
                if ("VariableDefinition".equals(childName)) {
                    result = DOMVariableDefinition.repair(child) || result;
                    continue;
                }
                if ("Rule".equals(childName)) {
                    result = DOMRule.repair(child) || result;
                    continue;
                }
                if ("ObligationExpressions".equals(childName)) {
                    if (sawObligationExprs) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicy.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawObligationExprs = true;
                    result = DOMObligationExpression.repairList(child) || result;
                    continue;
                }
                if ("AdviceExpressions".equals(childName)) {
                    if (sawAdviceExprs) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicy.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawAdviceExprs = true;
                    result = DOMAdviceExpression.repairList(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementPolicy.removeChild(child);
                result = true;
            }
        }
        result = DOMUtil.repairIdentifierAttribute((Element)elementPolicy, (String)"PolicyId", (Log)logger) || result;
        result = DOMUtil.repairVersionAttribute((Element)elementPolicy, (String)"Version", (Log)logger) || result;
        result = DOMUtil.repairIdentifierAttribute((Element)elementPolicy, (String)"RuleCombiningAlgId", (Identifier)XACML3.ID_RULE_DENY_OVERRIDES, (Log)logger) || result;
        Identifier identifier = DOMUtil.getIdentifierAttribute((Node)elementPolicy, (String)"RuleCombiningAlgId");
        CombiningAlgorithm<Rule> combiningAlgorithmRule = null;
        try {
            combiningAlgorithmRule = CombiningAlgorithmFactory.newInstance().getRuleCombiningAlgorithm(identifier);
        }
        catch (FactoryException ex) {
            combiningAlgorithmRule = null;
        }
        if (combiningAlgorithmRule == null) {
            logger.warn((Object)("Setting invalid RuleCombiningAlgId attribute " + identifier.stringValue() + " to " + XACML3.ID_RULE_DENY_OVERRIDES.stringValue()));
            elementPolicy.setAttribute("RuleCombiningAlgId", XACML3.ID_RULE_DENY_OVERRIDES.stringValue());
            result = true;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            for (String fileName : args) {
                File filePolicy = new File(fileName);
                if (filePolicy.exists() && filePolicy.canRead()) {
                    try {
                        Document documentPolicy = DOMUtil.loadDocument((File)filePolicy);
                        if (documentPolicy.getFirstChild() == null) {
                            System.err.println(fileName + ": Error: No Policy found");
                            continue;
                        }
                        if (!"Policy".equals(documentPolicy.getFirstChild().getLocalName())) {
                            System.err.println(fileName + ": Error: Not a Policy documnt");
                            continue;
                        }
                        Policy policy = DOMPolicy.newInstance(documentPolicy.getFirstChild(), null, null);
                        System.out.println(fileName + ": validate()=" + policy.validate());
                        System.out.println(StringUtils.prettyPrint((String)policy.toString()));
                    }
                    catch (Exception ex) {
                        System.err.println("Exception processing policy file \"" + fileName + "\"");
                        ex.printStackTrace(System.err);
                    }
                    continue;
                }
                System.err.println("Cannot read policy file \"" + fileName + "\"");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

