/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMPolicyRepair {
    private static final String DEFAULT_VERSION = "1.0";

    public static void main(String[] args) {
        InputStream inputStream = System.in;
        OutputStream outputStream = System.out;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-i")) {
                if (i + 1 < args.length) {
                    try {
                        inputStream = new FileInputStream(args[i + 1]);
                    }
                    catch (IOException ex) {
                        System.err.println("IOException opening \"" + args[i + 1] + "\" for reading.");
                        System.exit(1);
                    }
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            if (args[i].equals("-o")) {
                if (i + 1 < args.length) {
                    try {
                        outputStream = new FileOutputStream(args[i + 1]);
                    }
                    catch (IOException ex) {
                        System.err.println("IOException opening \"" + args[i + 1] + "\" for writing.");
                        ex.printStackTrace(System.err);
                        System.exit(1);
                    }
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            System.err.println("Unrecognized command line option \"" + args[i] + "\"");
            System.exit(1);
        }
        try {
            Document documentInput = DOMUtil.loadDocument((InputStream)inputStream);
            Element elementRoot = DOMUtil.getFirstChildElement((Node)documentInput);
            if (elementRoot == null) {
                System.err.println("No root element");
                System.exit(1);
            } else if (!"Policy".equals(elementRoot.getLocalName()) && !"PolicySet".equals(elementRoot.getLocalName())) {
                System.err.println("Root element is not a Policy or PolicySet");
                System.exit(1);
            }
            Node nodeVersion = DOMUtil.getAttribute((Node)elementRoot, (String)"Version");
            if (nodeVersion == null) {
                System.out.println("Adding Version attribute with value \"1.0\"");
                elementRoot.setAttribute("Version", DEFAULT_VERSION);
            }
            String newDocument = DOMUtil.toString((Document)documentInput);
            ((OutputStream)outputStream).write(newDocument.getBytes());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

