/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.Condition;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.policy.RuleEffect;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAdviceExpression;
import org.apache.openaz.xacml.pdp.policy.dom.DOMExpression;
import org.apache.openaz.xacml.pdp.policy.dom.DOMObligationExpression;
import org.apache.openaz.xacml.pdp.policy.dom.DOMTarget;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRule
extends Rule {
    private static final Log logger = LogFactory.getLog(DOMRule.class);

    protected DOMRule() {
    }

    public static Rule newInstance(Node nodeRule, Policy policy) throws DOMStructureException {
        DOMRule domRule;
        block17: {
            Element elementRule = DOMUtil.getElement((Node)nodeRule);
            boolean bLenient = DOMProperties.isLenient();
            domRule = new DOMRule();
            domRule.setPolicy(policy);
            try {
                int numChildren;
                NodeList children = elementRule.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                            Iterator<PolicyComponent> iterator;
                            String childName = child.getLocalName();
                            if ("Description".equals(childName)) {
                                if (domRule.getDescription() != null && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRule);
                                }
                                domRule.setDescription(child.getTextContent());
                                continue;
                            }
                            if ("Target".equals(childName)) {
                                if (domRule.getTarget() != null && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRule);
                                }
                                domRule.setTarget(DOMTarget.newInstance(child));
                                continue;
                            }
                            if ("Condition".equals(childName)) {
                                if (domRule.getCondition() != null && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRule);
                                }
                                Element nodeExpression = DOMUtil.getFirstChildElement((Node)child);
                                if (nodeExpression == null && !bLenient) {
                                    throw DOMUtil.newMissingElementException((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Expression");
                                }
                                domRule.setCondition(new Condition(DOMExpression.newInstance(nodeExpression, policy)));
                                continue;
                            }
                            if ("ObligationExpressions".equals(childName)) {
                                iterator = domRule.getObligationExpressions();
                                if (iterator != null && iterator.hasNext() && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRule);
                                }
                                domRule.setObligationExpressions(DOMObligationExpression.newList(child, policy));
                                continue;
                            }
                            if ("AdviceExpressions".equals(childName)) {
                                iterator = domRule.getAdviceExpressions();
                                if (iterator != null && iterator.hasNext() && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRule);
                                }
                                domRule.setAdviceExpressions(DOMAdviceExpression.newList(child, policy));
                                continue;
                            }
                            if (bLenient) continue;
                            throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRule);
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRule);
                    }
                }
                domRule.setRuleId(DOMUtil.getStringAttribute((Node)elementRule, (String)"RuleId", (!bLenient ? 1 : 0) != 0));
                String string = DOMUtil.getStringAttribute((Node)elementRule, (String)"Effect", (!bLenient ? 1 : 0) != 0);
                RuleEffect ruleEffect = RuleEffect.getRuleEffect(string);
                if (ruleEffect == null && !bLenient) {
                    throw new DOMStructureException((Node)elementRule, "Unknown RuleEffect \"" + string + "\" in \"" + DOMUtil.getNodeLabel((Node)nodeRule) + "\"");
                }
                domRule.setRuleEffect(ruleEffect);
            }
            catch (DOMStructureException ex) {
                domRule.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block17;
                throw ex;
            }
        }
        return domRule;
    }

    public static boolean repair(Node nodeRule) throws DOMStructureException {
        int numChildren;
        Element elementRule = DOMUtil.getElement((Node)nodeRule);
        boolean result = false;
        NodeList children = elementRule.getChildNodes();
        boolean sawDescription = false;
        boolean sawTarget = false;
        boolean sawCondition = false;
        boolean sawObligationExpressions = false;
        boolean sawAdviceExpressions = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("Description".equals(childName)) {
                        if (sawDescription) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementRule.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawDescription = true;
                        continue;
                    }
                    if ("Target".equals(childName)) {
                        if (sawTarget) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementRule.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawTarget = true;
                        result = DOMTarget.repair(child) || result;
                        continue;
                    }
                    if ("Condition".equals(childName)) {
                        if (sawCondition) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementRule.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawCondition = true;
                        Element nodeExpression = DOMUtil.getFirstChildElement((Node)child);
                        if (nodeExpression == null) {
                            throw DOMUtil.newMissingElementException((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Expression");
                        }
                        result = DOMExpression.repair(nodeExpression) || result;
                        continue;
                    }
                    if ("ObligationExpressions".equals(childName)) {
                        if (sawObligationExpressions) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementRule.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawObligationExpressions = true;
                        result = DOMObligationExpression.repairList(child) || result;
                        continue;
                    }
                    if ("AdviceExpressions".equals(childName)) {
                        if (sawAdviceExpressions) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementRule.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawAdviceExpressions = true;
                        result = DOMAdviceExpression.repairList(child) || result;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementRule.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementRule.removeChild(child);
                result = true;
            }
        }
        result = DOMUtil.repairStringAttribute((Element)elementRule, (String)"RuleId", (String)IdentifierImpl.gensym().stringValue(), (Log)logger) || result;
        result = DOMUtil.repairStringAttribute((Element)elementRule, (String)"Effect", (String)RuleEffect.DENY.getName(), (Log)logger) || result;
        String string = DOMUtil.getStringAttribute((Node)elementRule, (String)"Effect");
        RuleEffect ruleEffect = RuleEffect.getRuleEffect(string);
        if (ruleEffect == null) {
            logger.warn((Object)("Setting invalid Effect attribute " + string + " to " + RuleEffect.DENY.getName()));
            elementRule.setAttribute("Effect", RuleEffect.DENY.getName());
            result = true;
        }
        return result;
    }
}

