/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionBagIsIn<I>
extends FunctionDefinitionBase<Boolean, I> {
    public FunctionDefinitionBagIsIn(Identifier idIn, DataType<I> dataTypeArgsIn) {
        super(idIn, DataTypes.DT_BOOLEAN, dataTypeArgsIn, false);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        if (arguments == null || arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 2 arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        FunctionArgument elementArgument = arguments.get(0);
        ConvertedArgument convertedTargetArgument = new ConvertedArgument(elementArgument, this.getDataTypeArgs(), false);
        if (!convertedTargetArgument.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedTargetArgument.getStatus()));
        }
        AttributeValue<?> attributeValueElement = elementArgument.getValue();
        FunctionArgument bagArgument = arguments.get(1);
        ConvertedArgument convertedBagArgument = new ConvertedArgument(bagArgument, null, true);
        if (!convertedBagArgument.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedBagArgument.getStatus()));
        }
        Bag bag = convertedBagArgument.getBag();
        Iterator<AttributeValue<?>> iterBagContents = bag.getAttributeValues();
        while (iterBagContents.hasNext()) {
            AttributeValue<?> attributeValueBagContents = iterBagContents.next();
            if (!attributeValueElement.equals(attributeValueBagContents)) continue;
            return ER_TRUE;
        }
        return ER_FALSE;
    }
}

