/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.math.BigInteger;
import java.util.List;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionBagSize<I>
extends FunctionDefinitionBase<BigInteger, I> {
    public FunctionDefinitionBagSize(Identifier idIn, DataType<I> dataTypeArgsIn) {
        super(idIn, DataTypes.DT_INTEGER, dataTypeArgsIn, false);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        if (arguments == null || arguments.size() != 1) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 1 argument, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        FunctionArgument argument = arguments.get(0);
        ConvertedArgument convertedArgument = new ConvertedArgument(argument, null, true);
        if (!convertedArgument.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedArgument.getStatus()));
        }
        Bag bag = convertedArgument.getBag();
        if (bag == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Bag is null"));
        }
        StdAttributeValue resultAttributeValue = new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)BigInteger.valueOf(bag.size()));
        return ExpressionResult.newSingle(resultAttributeValue);
    }
}

