/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionHomogeneousSimple;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionLogical
extends FunctionDefinitionHomogeneousSimple<Boolean, Boolean> {
    private final OPERATION operation;

    public FunctionDefinitionLogical(Identifier idIn, OPERATION op) {
        super(idIn, DataTypes.DT_BOOLEAN, DataTypes.DT_BOOLEAN, (Integer)null);
        this.operation = op;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        switch (this.operation) {
            case OR: {
                if (arguments == null || arguments.size() == 0) {
                    return ER_FALSE;
                }
                try {
                    for (int i = 0; i < arguments.size(); ++i) {
                        ConvertedArgument argument = new ConvertedArgument(arguments.get(i), this.getDataTypeArgs(), false);
                        if (!argument.isOk()) {
                            return ExpressionResult.newError(this.getFunctionStatus(argument.getStatus()));
                        }
                        if (!((Boolean)argument.getValue()).booleanValue()) continue;
                        return ER_TRUE;
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (e.getCause() != null) {
                        message = e.getCause().getMessage();
                    }
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
                }
                return ER_FALSE;
            }
            case AND: {
                if (arguments == null || arguments.size() == 0) {
                    return ER_TRUE;
                }
                try {
                    for (int i = 0; i < arguments.size(); ++i) {
                        ConvertedArgument argument = new ConvertedArgument(arguments.get(i), this.getDataTypeArgs(), false);
                        if (!argument.isOk()) {
                            return ExpressionResult.newError(this.getFunctionStatus(argument.getStatus()));
                        }
                        if (((Boolean)argument.getValue()).booleanValue()) continue;
                        return ER_FALSE;
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (e.getCause() != null) {
                        message = e.getCause().getMessage();
                    }
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
                }
                return ER_TRUE;
            }
            case N_OF: {
                int trueArgumentsSeen = 0;
                if (arguments == null || arguments.size() == 0) {
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 1 argument, got 0"));
                }
                try {
                    if (arguments.get(0) == null) {
                        return ER_TRUE;
                    }
                    if (!arguments.get(0).getStatus().isOk()) {
                        return ExpressionResult.newError(this.getFunctionStatus(arguments.get(0).getStatus()));
                    }
                    if (arguments.get(0).isBag()) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected a simple value, saw a bag"));
                    }
                    AttributeValue<?> attributeValue = arguments.get(0).getValue();
                    if (attributeValue == null) {
                        return ER_TRUE;
                    }
                    Integer argumentCountNeeded = DataTypes.DT_INTEGER.convert(attributeValue.getValue()).intValue();
                    if (argumentCountNeeded == 0) {
                        return ER_TRUE;
                    }
                    if (arguments.size() - 1 < argumentCountNeeded) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected " + argumentCountNeeded + " arguments but only " + (arguments.size() - 1) + " arguments in list after the count"));
                    }
                    for (int i = 1; i < arguments.size(); ++i) {
                        ConvertedArgument argument = new ConvertedArgument(arguments.get(i), this.getDataTypeArgs(), false);
                        if (!argument.isOk()) {
                            return ExpressionResult.newError(this.getFunctionStatus(argument.getStatus()));
                        }
                        if (((Boolean)argument.getValue()).booleanValue() && ++trueArgumentsSeen >= argumentCountNeeded) {
                            return ER_TRUE;
                        }
                        if (arguments.size() - i - 1 + trueArgumentsSeen >= argumentCountNeeded) continue;
                        return ER_FALSE;
                    }
                    return ER_FALSE;
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (e.getCause() != null) {
                        message = e.getCause().getMessage();
                    }
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
                }
            }
            case NOT: {
                if (arguments == null || arguments.size() != 1) {
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 1 argument, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
                }
                try {
                    ConvertedArgument argument = new ConvertedArgument(arguments.get(0), this.getDataTypeArgs(), false);
                    if (!argument.isOk()) {
                        return ExpressionResult.newError(this.getFunctionStatus(argument.getStatus()));
                    }
                    if (((Boolean)argument.getValue()).booleanValue()) {
                        return ER_FALSE;
                    }
                    return ER_TRUE;
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (e.getCause() != null) {
                        message = e.getCause().getMessage();
                    }
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
                }
            }
        }
        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Could not evaluate Logical function " + (Object)((Object)this.operation)));
    }

    public static enum OPERATION {
        OR,
        AND,
        N_OF,
        NOT;

    }
}

