/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPathExpression;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionHomogeneousSimple;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.datatypes.XPathExpressionWrapper;
import org.w3c.dom.NodeList;

public class FunctionDefinitionXPath<O>
extends FunctionDefinitionHomogeneousSimple<O, XPathExpressionWrapper> {
    private final OPERATION operation;
    AttributeValue<String> result;

    public FunctionDefinitionXPath(Identifier idIn, DataType<O> dataTypeIn, OPERATION op) {
        super(idIn, dataTypeIn, DataTypes.DT_XPATHEXPRESSION, op == OPERATION.COUNT ? 1 : 2);
        this.operation = op;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        ArrayList<NodeList> nodeListList = new ArrayList<NodeList>();
        ArrayList convertedArguments = new ArrayList();
        Status status = this.validateArguments(arguments, convertedArguments);
        if (!status.getStatusCode().equals((Object)StdStatusCode.STATUS_CODE_OK)) {
            return ExpressionResult.newError(this.getFunctionStatus(status));
        }
        if (evaluationContext == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Got null EvaluationContext"));
        }
        if (evaluationContext.getRequest() == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Got null Request in EvaluationContext"));
        }
        for (int i = 0; i < arguments.size(); ++i) {
            FunctionArgument functionArgument = arguments.get(i);
            if (functionArgument.isBag()) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Got bag at index " + i));
            }
            AttributeValue<?> attributeValueFunctionArgument = functionArgument.getValue();
            if (attributeValueFunctionArgument == null) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Got null value at index " + i));
            }
            Identifier xpathCategory = attributeValueFunctionArgument.getXPathCategory();
            if (xpathCategory == null) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, this.getShortFunctionId() + " Got null Category at index " + i));
            }
            Iterator it = evaluationContext.getRequest().getRequestAttributes(xpathCategory);
            if (it == null) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, this.getShortFunctionId() + " Got null Iterator at index " + i));
            }
            NodeList nodeList = null;
            while (it.hasNext()) {
                if (nodeList != null) {
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, this.getShortFunctionId() + " More than one Content section for id '" + xpathCategory + "'"));
                }
                RequestAttributes requestAttributes = (RequestAttributes)it.next();
                if (requestAttributes.getContentRoot() == null) {
                    if (this.operation == OPERATION.COUNT) {
                        return ExpressionResult.newSingle(new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)BigInteger.ZERO));
                    }
                    return ER_FALSE;
                }
                try {
                    XPathExpression xPathExpression = ((XPathExpressionWrapper)convertedArguments.get(i)).getXpathExpressionWrapped();
                    nodeList = requestAttributes.getContentNodeListByXpathExpression(xPathExpression);
                }
                catch (Exception e) {
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, this.getShortFunctionId() + " XPath produces null result at '" + ((XPathExpressionWrapper)convertedArguments.get(i)).getPath() + "' at index " + i));
                }
            }
            if (nodeList == null) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " XPathExpression returned null at index " + i));
            }
            nodeListList.add(nodeList);
        }
        ExpressionResult expressionResult = null;
        switch (this.operation) {
            case COUNT: {
                Integer listLength = new Integer(((NodeList)nodeListList.get(0)).getLength());
                expressionResult = ExpressionResult.newSingle(new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)new BigInteger(listLength.toString())));
                return expressionResult;
            }
            case EQUAL: {
                for (int index0 = 0; index0 < ((NodeList)nodeListList.get(0)).getLength(); ++index0) {
                    for (int index1 = 0; index1 < ((NodeList)nodeListList.get(1)).getLength(); ++index1) {
                        if (!((NodeList)nodeListList.get(0)).item(index0).isSameNode(((NodeList)nodeListList.get(1)).item(index1))) continue;
                        return ER_TRUE;
                    }
                }
                return ER_FALSE;
            }
            case MATCH: {
                expressionResult = this.nodeListMatch((NodeList)nodeListList.get(0), (NodeList)nodeListList.get(1));
                return expressionResult;
            }
        }
        expressionResult = ExpressionResult.newSingle(this.result);
        return expressionResult;
    }

    private ExpressionResult nodeListMatch(NodeList list1, NodeList list2) {
        int index1;
        for (index1 = 0; index1 < list1.getLength(); ++index1) {
            for (int index2 = 0; index2 < list2.getLength(); ++index2) {
                if (!list1.item(index1).isSameNode(list2.item(index2))) continue;
                return ER_TRUE;
            }
        }
        for (index1 = 0; index1 < list1.getLength(); ++index1) {
            if (this.nodeListMatch(list1.item(index1).getChildNodes(), list2) != ER_TRUE) continue;
            return ER_TRUE;
        }
        return ER_FALSE;
    }

    public static enum OPERATION {
        COUNT,
        EQUAL,
        MATCH;

    }
}

