/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.eval.Matchable;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.policy.FunctionArgumentAttributeValue;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinition;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinitionFactory;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.expressions.AttributeRetrievalBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.util.FactoryException;

public class Match
extends PolicyComponent
implements Matchable {
    private Identifier matchId;
    private AttributeValue<?> attributeValue;
    private AttributeRetrievalBase attributeRetrievalBase;
    private PolicyDefaults policyDefaults;
    private FunctionDefinition functionDefinition;

    protected FunctionDefinition getFunctionDefinition() {
        Identifier functionDefinitionId = this.getMatchId();
        if (this.functionDefinition == null && functionDefinitionId != null) {
            try {
                this.functionDefinition = FunctionDefinitionFactory.newInstance().getFunctionDefinition(functionDefinitionId);
            }
            catch (FactoryException ex) {
                this.setStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "FactoryException getting FunctionDefinition");
            }
        }
        return this.functionDefinition;
    }

    public Match(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public Match(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public Match() {
    }

    public Match(Identifier matchIdIn, AttributeValue<?> attributeValueIn, AttributeRetrievalBase attributeRetrievalBaseIn, PolicyDefaults policyDefaultsIn) {
        this(StdStatusCode.STATUS_CODE_OK);
        this.matchId = matchIdIn;
        this.attributeValue = attributeValueIn;
        this.attributeRetrievalBase = attributeRetrievalBaseIn;
        this.policyDefaults = policyDefaultsIn;
    }

    public Identifier getMatchId() {
        return this.matchId;
    }

    public void setMatchId(Identifier matchIdIn) {
        this.matchId = matchIdIn;
    }

    public AttributeValue<?> getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(AttributeValue<?> attributeValueIn) {
        this.attributeValue = attributeValueIn;
    }

    public AttributeRetrievalBase getAttributeRetrievalBase() {
        return this.attributeRetrievalBase;
    }

    public void setAttributeRetrievalBase(AttributeRetrievalBase attributeRetrievalBaseIn) {
        this.attributeRetrievalBase = attributeRetrievalBaseIn;
    }

    public PolicyDefaults getPolicyDefaults() {
        return this.policyDefaults;
    }

    public void setPolicyDefaults(PolicyDefaults policyDefaultsIn) {
        this.policyDefaults = policyDefaultsIn;
    }

    private static MatchResult match(EvaluationContext evaluationContext, FunctionDefinition functionDefinition, FunctionArgument arg1, FunctionArgument arg2) throws EvaluationException {
        ArrayList<FunctionArgument> listArguments = new ArrayList<FunctionArgument>(2);
        listArguments.add(arg1);
        listArguments.add(arg2);
        ExpressionResult expressionResult = functionDefinition.evaluate(evaluationContext, listArguments);
        assert (expressionResult != null);
        if (!expressionResult.isOk()) {
            return new MatchResult(expressionResult.getStatus());
        }
        AttributeValue attributeValueResult = null;
        try {
            attributeValueResult = DataTypes.DT_BOOLEAN.convertAttributeValue(expressionResult.getValue());
        }
        catch (DataTypeException ex) {
            return new MatchResult((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, ex.getMessage()));
        }
        if (attributeValueResult == null) {
            return new MatchResult((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Non-boolean result from Match Function " + functionDefinition.getId() + " on " + expressionResult.getValue().toString()));
        }
        if (((Boolean)attributeValueResult.getValue()).booleanValue()) {
            return MatchResult.MM_MATCH;
        }
        return MatchResult.MM_NOMATCH;
    }

    @Override
    public MatchResult match(EvaluationContext evaluationContext) throws EvaluationException {
        if (!this.validate()) {
            return new MatchResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        FunctionDefinition functionDefinitionMatch = this.getFunctionDefinition();
        assert (functionDefinitionMatch != null);
        AttributeValue<?> attributeValue = this.getAttributeValue();
        assert (attributeValue != null);
        FunctionArgumentAttributeValue functionArgument1 = new FunctionArgumentAttributeValue(attributeValue);
        AttributeRetrievalBase attributeRetrievalBase = this.getAttributeRetrievalBase();
        assert (attributeRetrievalBase != null);
        ExpressionResult expressionResult = attributeRetrievalBase.evaluate(evaluationContext, this.getPolicyDefaults());
        assert (expressionResult != null);
        if (!expressionResult.isOk()) {
            return new MatchResult(expressionResult.getStatus());
        }
        if (expressionResult.isBag()) {
            MatchResult matchResult = MatchResult.MM_NOMATCH;
            Bag bagAttributeValues = expressionResult.getBag();
            if (bagAttributeValues != null) {
                Iterator<AttributeValue<?>> iterAttributeValues = bagAttributeValues.getAttributeValues();
                while (matchResult.getMatchCode() != MatchResult.MatchCode.MATCH && iterAttributeValues.hasNext()) {
                    MatchResult matchResultValue = Match.match(evaluationContext, functionDefinitionMatch, functionArgument1, new FunctionArgumentAttributeValue(iterAttributeValues.next()));
                    switch (matchResultValue.getMatchCode()) {
                        case INDETERMINATE: {
                            if (matchResult.getMatchCode() == MatchResult.MatchCode.INDETERMINATE) break;
                            matchResult = matchResultValue;
                            break;
                        }
                        case MATCH: {
                            matchResult = matchResultValue;
                            break;
                        }
                    }
                }
            }
            return matchResult;
        }
        AttributeValue<?> attributeValueExpressionResult = expressionResult.getValue();
        if (attributeValueExpressionResult == null) {
            return new MatchResult((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Null AttributeValue"));
        }
        return Match.match(evaluationContext, functionDefinitionMatch, functionArgument1, new FunctionArgumentAttributeValue(attributeValueExpressionResult));
    }

    @Override
    protected boolean validateComponent() {
        if (this.getAttributeValue() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AttributeValue");
            return false;
        }
        if (this.getMatchId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing MatchId");
            return false;
        }
        FunctionDefinition functionDefinitionHere = this.getFunctionDefinition();
        if (functionDefinitionHere == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Unknown MatchId \"" + this.getMatchId().toString() + "\"");
            return false;
        }
        if (functionDefinitionHere.returnsBag()) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "FunctionDefinition returns a bag");
            return false;
        }
        if (functionDefinitionHere.getDataTypeId() == null || !functionDefinitionHere.getDataTypeId().equals((Object)XACML.ID_DATATYPE_BOOLEAN)) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Non-Boolean return type for FunctionDefinition");
            return false;
        }
        if (this.getAttributeRetrievalBase() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AttributeSelector or AttributeDesignator");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getMatchId();
        if (objectToDump != null) {
            stringBuilder.append(",matchId=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getAttributeValue()) != null) {
            stringBuilder.append(",attributeValue=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getAttributeRetrievalBase()) != null) {
            stringBuilder.append(",attributeRetrieval=");
            stringBuilder.append(objectToDump.toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

