/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.trace.TraceEvent;
import org.apache.openaz.xacml.api.trace.Traceable;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithm;
import org.apache.openaz.xacml.pdp.policy.CombiningElement;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.policy.TargetedCombinerParameter;
import org.apache.openaz.xacml.pdp.policy.TargetedCombinerParameterMap;
import org.apache.openaz.xacml.pdp.policy.VariableDefinition;
import org.apache.openaz.xacml.pdp.policy.VariableMap;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.trace.StdTraceEvent;
import org.apache.openaz.xacml.util.StringUtils;

public class Policy
extends PolicyDef {
    private TargetedCombinerParameterMap<String, Rule> ruleCombinerParameters = new TargetedCombinerParameterMap();
    private VariableMap variableMap = new VariableMap();
    private List<Rule> rules = new ArrayList<Rule>();
    private List<CombiningElement<Rule>> combiningRules;
    private CombiningAlgorithm<Rule> ruleCombiningAlgorithm;

    @Override
    protected boolean validateComponent() {
        if (super.validateComponent()) {
            if (this.getRuleCombiningAlgorithm() == null) {
                this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing rule combining algorithm");
                return false;
            }
            return true;
        }
        return false;
    }

    protected List<CombiningElement<Rule>> getCombiningRules() {
        if (this.combiningRules == null) {
            this.combiningRules = new ArrayList<CombiningElement<Rule>>();
            Iterator<Rule> iterRules = this.getRules();
            while (iterRules.hasNext()) {
                Rule rule = iterRules.next();
                this.combiningRules.add(new CombiningElement<Rule>(rule, this.ruleCombinerParameters.getCombinerParameters(rule)));
            }
        }
        return this.combiningRules;
    }

    public Policy(PolicySet policySetParent, StatusCode statusCodeIn, String statusMessageIn) {
        super(policySetParent, statusCodeIn, statusMessageIn);
    }

    public Policy(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public Policy(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public Policy(PolicySet policySetParent) {
        super(policySetParent);
    }

    public Policy() {
        this.ruleCombinerParameters.getTargetedCombinerParameters();
    }

    public Iterator<TargetedCombinerParameter<String, Rule>> getRuleCombinerParameters() {
        return this.ruleCombinerParameters.getTargetedCombinerParameters();
    }

    public void setRuleCombinerParameters(Collection<TargetedCombinerParameter<String, Rule>> ruleCombinerParameters) {
        this.ruleCombinerParameters.setCombinerParameters(ruleCombinerParameters);
    }

    public void addRuleCombinerParameter(TargetedCombinerParameter<String, Rule> ruleCombinerParameter) {
        this.ruleCombinerParameters.addCombinerParameter(ruleCombinerParameter);
    }

    public void addRuleCombinerParameters(Collection<TargetedCombinerParameter<String, Rule>> ruleCombinerParameters) {
        this.ruleCombinerParameters.addCombinerParameters(ruleCombinerParameters);
    }

    public Iterator<VariableDefinition> getVariableDefinitions() {
        return this.variableMap.getVariableDefinitions();
    }

    public VariableDefinition getVariableDefinition(String variableId) {
        return this.variableMap.getVariableDefinition(variableId);
    }

    public void setVariableDefinitions(Collection<VariableDefinition> listVariableDefinitions) {
        this.variableMap.setVariableDefinitions(listVariableDefinitions);
    }

    public void addVariableDefinition(VariableDefinition variableDefinition) {
        this.variableMap.add(variableDefinition);
    }

    public void addVariableDefinitions(Collection<VariableDefinition> variableDefinitions) {
        this.variableMap.addVariableDefinitions(variableDefinitions);
    }

    public Iterator<Rule> getRules() {
        return this.rules.iterator();
    }

    public void setRules(Collection<Rule> listRules) {
        this.rules.clear();
        if (listRules != null) {
            this.addRules(listRules);
        }
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void addRules(Collection<Rule> listRules) {
        this.rules.addAll(listRules);
    }

    public CombiningAlgorithm<Rule> getRuleCombiningAlgorithm() {
        return this.ruleCombiningAlgorithm;
    }

    public void setRuleCombiningAlgorithm(CombiningAlgorithm<Rule> ruleCombiningAlgorithmIn) {
        this.ruleCombiningAlgorithm = ruleCombiningAlgorithmIn;
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext evaluationContext) throws EvaluationException {
        if (!this.validate()) {
            return new EvaluationResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        MatchResult thisMatchResult = this.match(evaluationContext);
        assert (thisMatchResult != null);
        if (evaluationContext.isTracing()) {
            evaluationContext.trace((TraceEvent)new StdTraceEvent("Match", (Traceable)this, (Object)thisMatchResult));
        }
        switch (thisMatchResult.getMatchCode()) {
            case INDETERMINATE: {
                return new EvaluationResult(Decision.INDETERMINATE, thisMatchResult.getStatus());
            }
            case MATCH: {
                break;
            }
            case NOMATCH: {
                return new EvaluationResult(Decision.NOTAPPLICABLE);
            }
        }
        List ruleCombiningElements = this.getCombiningRules();
        assert (ruleCombiningElements != null);
        assert (this.getRuleCombiningAlgorithm() != null);
        EvaluationResult evaluationResultCombined = this.getRuleCombiningAlgorithm().combine(evaluationContext, ruleCombiningElements, this.getCombinerParameterList());
        assert (evaluationResultCombined != null);
        if (evaluationContext.getRequest().getReturnPolicyIdList()) {
            evaluationResultCombined.addPolicyIdentifier(this.getIdReference());
        }
        if (evaluationResultCombined.getDecision() == Decision.DENY || evaluationResultCombined.getDecision() == Decision.PERMIT) {
            this.updateResult(evaluationResultCombined, evaluationContext);
        }
        if (evaluationContext.isTracing()) {
            evaluationContext.trace((TraceEvent)new StdTraceEvent("Result", (Traceable)this, (Object)evaluationResultCombined));
        }
        return evaluationResultCombined;
    }

    @Override
    public String toString() {
        CombiningAlgorithm<Rule> objectToDump;
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        String iteratorToDump = StringUtils.toString(this.getRuleCombinerParameters());
        if (iteratorToDump != null) {
            stringBuilder.append(",ruleCombinerParameters=");
            stringBuilder.append(iteratorToDump);
        }
        if ((iteratorToDump = StringUtils.toString(this.getVariableDefinitions())) != null) {
            stringBuilder.append(",variableDefinitions=");
            stringBuilder.append(iteratorToDump);
        }
        if ((iteratorToDump = StringUtils.toString(this.getRules())) != null) {
            stringBuilder.append(",rules=");
            stringBuilder.append(iteratorToDump);
        }
        if ((objectToDump = this.getRuleCombiningAlgorithm()) != null) {
            stringBuilder.append(",ruleCombiningAlgorithm=");
            stringBuilder.append(objectToDump.toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

