/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.std.StdStatusCode;

abstract class PolicyComponent {
    private StatusCode statusCode;
    private String statusMessage;

    public PolicyComponent(StatusCode statusCodeIn, String statusMessageIn) {
        this.statusCode = statusCodeIn;
        this.statusMessage = statusMessageIn;
    }

    public PolicyComponent(StatusCode statusCodeIn) {
        this(statusCodeIn, null);
    }

    public PolicyComponent() {
        this(null, null);
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatus(StatusCode statusCodeIn, String messageIn) {
        this.statusCode = statusCodeIn;
        this.statusMessage = messageIn;
    }

    public boolean isOk() {
        return StdStatusCode.STATUS_CODE_OK.equals((Object)this.getStatusCode());
    }

    protected abstract boolean validateComponent();

    public boolean validate() {
        if (this.getStatusCode() == null) {
            return this.validateComponent();
        }
        return this.isOk();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Object objectToDump = this.getStatusCode();
        if (objectToDump != null) {
            stringBuilder.append("statusCode=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getStatusMessage()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("statusMessage=");
            stringBuilder.append((String)objectToDump);
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

