/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openaz.xacml.pdp.policy.VariableDefinition;
import org.apache.openaz.xacml.util.StringUtils;

public class VariableMap {
    private List<VariableDefinition> variableDefinitions;
    private Map<String, VariableDefinition> mapVariableDefinitions;

    private void ensureVariableDefinitions() {
        if (this.variableDefinitions == null) {
            this.variableDefinitions = new ArrayList<VariableDefinition>();
        }
    }

    private void ensureMap() {
        if (this.mapVariableDefinitions == null) {
            this.mapVariableDefinitions = new HashMap<String, VariableDefinition>();
        }
    }

    public VariableDefinition getVariableDefinition(String variableId) {
        return this.mapVariableDefinitions == null ? null : this.mapVariableDefinitions.get(variableId);
    }

    public Iterator<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions == null ? null : this.variableDefinitions.iterator();
    }

    public void add(VariableDefinition variableDefinition) {
        this.ensureMap();
        this.ensureVariableDefinitions();
        this.variableDefinitions.add(variableDefinition);
        this.mapVariableDefinitions.put(variableDefinition.getId(), variableDefinition);
    }

    public void addVariableDefinitions(Collection<VariableDefinition> listVariableDefinitions) {
        for (VariableDefinition variableDefinition : listVariableDefinitions) {
            this.add(variableDefinition);
        }
    }

    public void setVariableDefinitions(Collection<VariableDefinition> listVariableDefinitions) {
        this.variableDefinitions = null;
        this.mapVariableDefinitions = null;
        if (listVariableDefinitions != null) {
            this.addVariableDefinitions(this.variableDefinitions);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        if (this.mapVariableDefinitions.size() > 0) {
            stringBuilder.append("variableDefinitions=");
            stringBuilder.append(StringUtils.toString(this.mapVariableDefinitions.values().iterator()));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

