/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.AnyOf;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAllOf;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAnyOf
extends AnyOf {
    private static final Log logger = LogFactory.getLog(DOMAnyOf.class);

    protected DOMAnyOf() {
    }

    public static AnyOf newInstance(Node nodeAnyOf) throws DOMStructureException {
        DOMAnyOf domAnyOf;
        block5: {
            Element elementAnyOf = DOMUtil.getElement((Node)nodeAnyOf);
            boolean bLenient = DOMProperties.isLenient();
            domAnyOf = new DOMAnyOf();
            try {
                int numChildren;
                NodeList children = elementAnyOf.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AllOf".equals(child.getLocalName())) {
                            domAnyOf.addAllOf(DOMAllOf.newInstance(child));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeAnyOf);
                    }
                }
            }
            catch (DOMStructureException ex) {
                domAnyOf.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block5;
                throw ex;
            }
        }
        return domAnyOf;
    }

    public static boolean repair(Node nodeAnyOf) throws DOMStructureException {
        int numChildren;
        Element elementAnyOf = DOMUtil.getElement((Node)nodeAnyOf);
        boolean result = false;
        NodeList children = elementAnyOf.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AllOf".equals(child.getLocalName())) {
                    result = DOMAllOf.repair(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementAnyOf.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

