/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.policy.AttributeAssignmentExpression;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.dom.DOMExpression;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMAttributeAssignmentExpression
extends AttributeAssignmentExpression {
    private static final Log logger = LogFactory.getLog(DOMAttributeAssignmentExpression.class);

    protected DOMAttributeAssignmentExpression() {
    }

    public static AttributeAssignmentExpression newInstance(Node nodeAttributeAssignmentExpression, Policy policy) throws DOMStructureException {
        DOMAttributeAssignmentExpression domAttributeAssignmentExpression;
        block7: {
            Element elementAttributeAssignmentExpression = DOMUtil.getElement((Node)nodeAttributeAssignmentExpression);
            boolean bLenient = DOMProperties.isLenient();
            domAttributeAssignmentExpression = new DOMAttributeAssignmentExpression();
            try {
                String issuer;
                Element node = DOMUtil.getFirstChildElement((Node)elementAttributeAssignmentExpression);
                if (node == null) {
                    if (!bLenient) {
                        throw DOMUtil.newMissingElementException((Node)elementAttributeAssignmentExpression, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Expression");
                    }
                } else {
                    domAttributeAssignmentExpression.setExpression(DOMExpression.newInstance(node, policy));
                }
                domAttributeAssignmentExpression.setAttributeId(DOMUtil.getIdentifierAttribute((Node)elementAttributeAssignmentExpression, (String)"AttributeId", (!bLenient ? 1 : 0) != 0));
                Identifier identifier = DOMUtil.getIdentifierAttribute((Node)elementAttributeAssignmentExpression, (String)"Category");
                if (identifier != null) {
                    domAttributeAssignmentExpression.setCategory(identifier);
                }
                if ((issuer = DOMUtil.getStringAttribute((Node)elementAttributeAssignmentExpression, (String)"Issuer")) != null) {
                    domAttributeAssignmentExpression.setIssuer(issuer);
                }
            }
            catch (DOMStructureException ex) {
                domAttributeAssignmentExpression.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block7;
                throw ex;
            }
        }
        return domAttributeAssignmentExpression;
    }

    public static boolean repair(Node nodeAttributeAssignmentExpression) throws DOMStructureException {
        Element elementAttributeAssignmentExpression = DOMUtil.getElement((Node)nodeAttributeAssignmentExpression);
        boolean result = false;
        if (DOMUtil.getFirstChildElement((Node)elementAttributeAssignmentExpression) == null) {
            Identifier identifier = DOMUtil.getIdentifierAttribute((Node)elementAttributeAssignmentExpression, (String)"DataType");
            String textContent = elementAttributeAssignmentExpression.getTextContent();
            if (textContent != null) {
                textContent = textContent.trim();
            }
            if (textContent != null && textContent.length() > 0 && identifier != null) {
                Element attributeValue = elementAttributeAssignmentExpression.getOwnerDocument().createElementNS("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "AttributeValue");
                attributeValue.setAttribute("DataType", identifier.stringValue());
                attributeValue.setTextContent(textContent);
                logger.warn((Object)"Adding a new AttributeValue using the DataType from the AttributeAssignment");
                elementAttributeAssignmentExpression.removeAttribute("DataType");
                while (elementAttributeAssignmentExpression.hasChildNodes()) {
                    elementAttributeAssignmentExpression.removeChild(elementAttributeAssignmentExpression.getFirstChild());
                }
                elementAttributeAssignmentExpression.appendChild(attributeValue);
                result = true;
            } else {
                throw DOMUtil.newMissingElementException((Node)elementAttributeAssignmentExpression, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Expression");
            }
        }
        result = DOMUtil.repairIdentifierAttribute((Element)elementAttributeAssignmentExpression, (String)"AttributeId", (Log)logger) || result;
        return result;
    }
}

