/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMCombinerParameter
extends CombinerParameter {
    private static final Log logger = LogFactory.getLog(DOMCombinerParameter.class);

    protected DOMCombinerParameter() {
    }

    public static CombinerParameter newInstance(Node nodeCombinerParameter) throws DOMStructureException {
        DOMCombinerParameter combinerParameter;
        block7: {
            Element elementCombinerParameter = DOMUtil.getElement((Node)nodeCombinerParameter);
            boolean bLenient = DOMProperties.isLenient();
            combinerParameter = new DOMCombinerParameter();
            try {
                int numChildren;
                NodeList children = elementCombinerParameter.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeValue".equals(child.getLocalName())) {
                            if (combinerParameter.getAttributeValue() != null && !bLenient) {
                                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)elementCombinerParameter);
                            }
                            combinerParameter.setAttributeValue(DOMAttributeValue.newInstance((Node)child, null));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)elementCombinerParameter);
                    }
                }
                if (combinerParameter.getAttributeValue() == null && !bLenient) {
                    throw DOMUtil.newMissingElementException((Node)elementCombinerParameter, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
                }
                combinerParameter.setName(DOMUtil.getStringAttribute((Node)elementCombinerParameter, (String)"ParameterName", (!bLenient ? 1 : 0) != 0));
            }
            catch (DOMStructureException ex) {
                combinerParameter.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block7;
                throw ex;
            }
        }
        return combinerParameter;
    }

    public static boolean repair(Node nodeCombinerParameter) throws DOMStructureException {
        int numChildren;
        Element elementCombinerParameter = DOMUtil.getElement((Node)nodeCombinerParameter);
        boolean result = false;
        NodeList children = elementCombinerParameter.getChildNodes();
        boolean sawAttributeValue = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeValue".equals(child.getLocalName())) {
                    if (sawAttributeValue) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementCombinerParameter.removeChild(child);
                        result = true;
                        continue;
                    }
                    result = DOMAttributeValue.repair((Node)child) || result;
                    sawAttributeValue = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementCombinerParameter.removeChild(child);
                result = true;
            }
        }
        if (!sawAttributeValue) {
            throw DOMUtil.newMissingElementException((Node)elementCombinerParameter, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
        }
        result = DOMUtil.repairStringAttribute((Element)elementCombinerParameter, (String)"ParameterName", (String)"parameter", (Log)logger) || result;
        return result;
    }

    public static List<CombinerParameter> newList(Node nodeCombinerParameters) throws DOMStructureException {
        int numChildren;
        Element elementCombinerParameters = DOMUtil.getElement((Node)nodeCombinerParameters);
        boolean bLenient = DOMProperties.isLenient();
        ArrayList<CombinerParameter> listCombinerParameters = new ArrayList<CombinerParameter>();
        NodeList children = elementCombinerParameters.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "CombinerParameter".equals(child.getLocalName())) {
                    listCombinerParameters.add(DOMCombinerParameter.newInstance(child));
                    continue;
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)elementCombinerParameters);
            }
        }
        return listCombinerParameters;
    }

    public static boolean repairList(Node nodeCombinerParameters) throws DOMStructureException {
        int numChildren;
        Element elementCombinerParameters = DOMUtil.getElement((Node)nodeCombinerParameters);
        boolean result = false;
        NodeList children = elementCombinerParameters.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "CombinerParameter".equals(child.getLocalName())) {
                    result = DOMCombinerParameter.repair(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementCombinerParameters.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

