/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicy;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicySet;
import org.apache.openaz.xacml.std.dom.DOMDocumentRepair;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMDocumentRepair
extends org.apache.openaz.xacml.std.dom.DOMDocumentRepair {
    protected boolean repairPolicy(Node nodePolicy) throws DOMStructureException {
        return DOMPolicy.repair(nodePolicy);
    }

    protected boolean repairPolicySet(Node nodePolicySet) throws DOMStructureException {
        return DOMPolicySet.repair(nodePolicySet);
    }

    public boolean repair(Document document) throws DOMStructureException, DOMDocumentRepair.UnsupportedDocumentTypeException {
        Element firstChild = DOMUtil.getFirstChildElement((Node)document);
        if (firstChild == null || !DOMUtil.isElement((Node)firstChild)) {
            return false;
        }
        if (!DOMUtil.isInNamespace((Node)firstChild, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
            throw new DOMDocumentRepair.UnsupportedDocumentTypeException("Not a XACML document: " + DOMUtil.getNodeLabel((Node)firstChild));
        }
        if ("Request".equals(firstChild.getLocalName())) {
            return this.repairRequest(firstChild);
        }
        if ("Response".equals(firstChild.getLocalName())) {
            return this.repairResponse(firstChild);
        }
        if ("Policy".equals(firstChild.getLocalName())) {
            return this.repairPolicy(firstChild);
        }
        if ("PolicySet".equals(firstChild.getLocalName())) {
            return this.repairPolicySet(firstChild);
        }
        throw new DOMDocumentRepair.UnsupportedDocumentTypeException("Not a XACML Request or Response: " + DOMUtil.getNodeLabel((Node)firstChild));
    }
}

