/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.pdp.policy.Expression;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.dom.DOMApply;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAttributeDesignator;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAttributeSelector;
import org.apache.openaz.xacml.pdp.policy.expressions.AttributeValueExpression;
import org.apache.openaz.xacml.pdp.policy.expressions.Function;
import org.apache.openaz.xacml.pdp.policy.expressions.VariableReference;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMExpression
extends Expression {
    private static final Log logger = LogFactory.getLog(DOMExpression.class);

    protected DOMExpression() {
    }

    public static boolean isExpression(Node nodeExpression) {
        String nodeName = nodeExpression.getLocalName();
        return "Apply".equals(nodeName) || "AttributeDesignator".equals(nodeName) || "AttributeSelector".equals(nodeName) || "AttributeValue".equals(nodeName) || "Function".equals(nodeName) || "VariableReference".equals(nodeName);
    }

    public static Expression newInstance(Node nodeExpression, Policy policy) throws DOMStructureException {
        Element elementExpression = DOMUtil.getElement((Node)nodeExpression);
        boolean bLenient = DOMProperties.isLenient();
        if (DOMUtil.isInNamespace((Node)elementExpression, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
            if (elementExpression.getLocalName().equals("Apply")) {
                return DOMApply.newInstance(elementExpression, policy);
            }
            if (elementExpression.getLocalName().equals("AttributeDesignator")) {
                return DOMAttributeDesignator.newInstance(elementExpression);
            }
            if (elementExpression.getLocalName().equals("AttributeSelector")) {
                return DOMAttributeSelector.newInstance(elementExpression);
            }
            if (elementExpression.getLocalName().equals("AttributeValue")) {
                AttributeValue attributeValue = null;
                try {
                    attributeValue = DOMAttributeValue.newInstance((Node)elementExpression, null);
                }
                catch (DOMStructureException ex) {
                    return new AttributeValueExpression(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                }
                return new AttributeValueExpression(attributeValue);
            }
            if (elementExpression.getLocalName().equals("Function")) {
                return new Function(DOMUtil.getIdentifierAttribute((Node)elementExpression, (String)"FunctionId"));
            }
            if (elementExpression.getLocalName().equals("VariableReference")) {
                return new VariableReference(policy, DOMUtil.getStringAttribute((Node)elementExpression, (String)"VariableId"));
            }
            if (!bLenient) {
                throw DOMUtil.newUnexpectedElementException((Node)nodeExpression);
            }
            return null;
        }
        if (!bLenient) {
            throw DOMUtil.newUnexpectedElementException((Node)nodeExpression);
        }
        return null;
    }

    public static boolean repair(Node nodeExpression) throws DOMStructureException {
        Element elementExpression = DOMUtil.getElement((Node)nodeExpression);
        if (DOMUtil.isInNamespace((Node)elementExpression, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
            if (elementExpression.getLocalName().equals("Apply")) {
                return DOMApply.repair(elementExpression);
            }
            if (elementExpression.getLocalName().equals("AttributeDesignator")) {
                return DOMAttributeDesignator.repair(elementExpression);
            }
            if (elementExpression.getLocalName().equals("AttributeSelector")) {
                return DOMAttributeSelector.repair(elementExpression);
            }
            if (elementExpression.getLocalName().equals("AttributeValue")) {
                return DOMAttributeValue.repair((Node)elementExpression);
            }
            if (elementExpression.getLocalName().equals("Function")) {
                return DOMUtil.repairIdentifierAttribute((Element)elementExpression, (String)"FunctionId", (Identifier)XACML3.ID_FUNCTION_STRING_EQUAL, (Log)logger);
            }
            if (elementExpression.getLocalName().equals("VariableReference")) {
                return DOMUtil.repairStringAttribute((Element)elementExpression, (String)"VariableId", (String)"variableId", (Log)logger);
            }
            throw DOMUtil.newUnexpectedElementException((Node)nodeExpression);
        }
        throw DOMUtil.newUnexpectedElementException((Node)nodeExpression);
    }
}

