/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.io.File;
import java.io.InputStream;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicy;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicySet;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMPolicyDef {
    protected DOMPolicyDef() {
    }

    protected static PolicyDef newInstance(Document document, PolicySet policySetParent) throws DOMStructureException {
        PolicyDef policyDef;
        block8: {
            policyDef = null;
            try {
                Element rootNode = DOMUtil.getFirstChildElement((Node)document);
                if (rootNode == null) {
                    throw new DOMStructureException("No child in document");
                }
                if (DOMUtil.isInNamespace((Node)rootNode, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Policy".equals(rootNode.getLocalName())) {
                        policyDef = DOMPolicy.newInstance(rootNode, policySetParent, null);
                        if (policyDef == null) {
                            throw new DOMStructureException("Failed to parse Policy");
                        }
                        break block8;
                    }
                    if ("PolicySet".equals(rootNode.getLocalName())) {
                        policyDef = DOMPolicySet.newInstance(rootNode, policySetParent, null);
                        if (policyDef == null) {
                            throw new DOMStructureException("Failed to parse PolicySet");
                        }
                        break block8;
                    }
                    throw DOMUtil.newUnexpectedElementException((Node)rootNode);
                }
                throw DOMUtil.newUnexpectedElementException((Node)rootNode);
            }
            catch (Exception ex) {
                throw new DOMStructureException("Exception parsing Policy: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return policyDef;
    }

    public static PolicyDef load(InputStream inputStream) throws DOMStructureException {
        PolicyDef policyDef = null;
        try {
            Document document = DOMUtil.loadDocument((InputStream)inputStream);
            if (document == null) {
                throw new DOMStructureException("Null document returned");
            }
            policyDef = DOMPolicyDef.newInstance(document, null);
        }
        catch (Exception ex) {
            throw new DOMStructureException("Exception loading Policy from input stream: " + ex.getMessage(), (Throwable)ex);
        }
        return policyDef;
    }

    public static PolicyDef load(File filePolicy) throws DOMStructureException {
        PolicyDef policyDef = null;
        try {
            Document document = DOMUtil.loadDocument((File)filePolicy);
            if (document == null) {
                throw new DOMStructureException("Null document returned");
            }
            policyDef = DOMPolicyDef.newInstance(document, null);
        }
        catch (Exception ex) {
            throw new DOMStructureException("Exception loading Policy file \"" + filePolicy.getAbsolutePath() + "\": " + ex.getMessage(), (Throwable)ex);
        }
        return policyDef;
    }
}

