/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithm;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithmFactory;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAdviceExpression;
import org.apache.openaz.xacml.pdp.policy.dom.DOMCombinerParameter;
import org.apache.openaz.xacml.pdp.policy.dom.DOMObligationExpression;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicy;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyCombinerParameter;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyIdReference;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyIssuer;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicySetCombinerParameter;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicySetIdReference;
import org.apache.openaz.xacml.pdp.policy.dom.DOMTarget;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPolicySet {
    private static final Log logger = LogFactory.getLog(DOMPolicySet.class);

    protected DOMPolicySet() {
    }

    public static PolicySet newInstance(Node nodePolicySet, PolicySet policySetParent, PolicyDefaults policyDefaultsParent) throws DOMStructureException {
        PolicySet domPolicySet;
        block31: {
            Element elementPolicySet = DOMUtil.getElement((Node)nodePolicySet);
            boolean bLenient = DOMProperties.isLenient();
            domPolicySet = new PolicySet(policySetParent);
            try {
                CombiningAlgorithm<PolicySetChild> combiningAlgorithm;
                Identifier identifier;
                block30: {
                    int numChildren;
                    NodeList children = elementPolicySet.getChildNodes();
                    if (children != null && (numChildren = children.getLength()) > 0) {
                        Node child;
                        int i;
                        for (i = 0; i < numChildren; ++i) {
                            child = children.item(i);
                            if (!DOMUtil.isNamespaceElement((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") || !"PolicyDefaults".equals(child.getLocalName())) continue;
                            if (domPolicySet.getPolicyDefaults() != null && !bLenient) {
                                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicySet);
                            }
                            domPolicySet.setPolicyDefaults(DOMPolicyDefaults.newInstance(child, policyDefaultsParent));
                        }
                        if (domPolicySet.getPolicyDefaults() == null) {
                            domPolicySet.setPolicyDefaults(policyDefaultsParent);
                        }
                        for (i = 0; i < numChildren; ++i) {
                            child = children.item(i);
                            if (!DOMUtil.isElement((Node)child)) continue;
                            if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                                Iterator<PolicyComponent> iterator;
                                String childName = child.getLocalName();
                                if ("Description".equals(childName)) {
                                    if (domPolicySet.getDescription() != null && !bLenient) {
                                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicySet);
                                    }
                                    domPolicySet.setDescription(child.getTextContent());
                                    continue;
                                }
                                if ("PolicyIssuer".equals(childName)) {
                                    if (domPolicySet.getPolicyIssuer() != null && !bLenient) {
                                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicySet);
                                    }
                                    domPolicySet.setPolicyIssuer(DOMPolicyIssuer.newInstance(child));
                                    continue;
                                }
                                if ("PolicySetDefaults".equals(childName)) continue;
                                if ("Target".equals(childName)) {
                                    if (domPolicySet.getTarget() != null && !bLenient) {
                                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicySet);
                                    }
                                    domPolicySet.setTarget(DOMTarget.newInstance(child));
                                    continue;
                                }
                                if ("PolicySet".equals(childName)) {
                                    domPolicySet.addChild(DOMPolicySet.newInstance(child, domPolicySet, domPolicySet.getPolicyDefaults()));
                                    continue;
                                }
                                if ("Policy".equals(childName)) {
                                    domPolicySet.addChild(DOMPolicy.newInstance(child, domPolicySet, domPolicySet.getPolicyDefaults()));
                                    continue;
                                }
                                if ("PolicyIdReference".equals(childName)) {
                                    domPolicySet.addChild(DOMPolicyIdReference.newInstance(child, domPolicySet));
                                    continue;
                                }
                                if ("PolicySetIdReference".equals(childName)) {
                                    domPolicySet.addChild(DOMPolicySetIdReference.newInstance(child, domPolicySet));
                                    continue;
                                }
                                if ("CombinerParameters".equals(childName)) {
                                    domPolicySet.addCombinerParameters(DOMCombinerParameter.newList(child));
                                    continue;
                                }
                                if ("PolicyCombinerParameters".equals(childName)) {
                                    domPolicySet.addPolicyCombinerParameter(DOMPolicyCombinerParameter.newInstance(child));
                                    continue;
                                }
                                if ("PolicySetCombinerParameters".equals(childName)) {
                                    domPolicySet.addPolicyCombinerParameter(DOMPolicySetCombinerParameter.newInstance(child));
                                    continue;
                                }
                                if ("ObligationExpressions".equals(childName)) {
                                    iterator = domPolicySet.getObligationExpressions();
                                    if (iterator != null && iterator.hasNext() && !bLenient) {
                                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicySet);
                                    }
                                    domPolicySet.setObligationExpressions(DOMObligationExpression.newList(child, null));
                                    continue;
                                }
                                if ("AdviceExpressions".equals(childName)) {
                                    iterator = domPolicySet.getAdviceExpressions();
                                    if (iterator != null && iterator.hasNext() && !bLenient) {
                                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicySet);
                                    }
                                    domPolicySet.setAdviceExpressions(DOMAdviceExpression.newList(child, null));
                                    continue;
                                }
                                if (bLenient) continue;
                                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicySet);
                            }
                            if (bLenient) continue;
                            throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodePolicySet);
                        }
                    }
                    if (domPolicySet.getTarget() == null && !bLenient) {
                        throw DOMUtil.newMissingElementException((Node)nodePolicySet, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Target");
                    }
                    domPolicySet.setIdentifier(DOMUtil.getIdentifierAttribute((Node)elementPolicySet, (String)"PolicySetId", (!bLenient ? 1 : 0) != 0));
                    domPolicySet.setVersion(DOMUtil.getVersionAttribute((Node)elementPolicySet, (String)"Version", (!bLenient ? 1 : 0) != 0));
                    identifier = DOMUtil.getIdentifierAttribute((Node)elementPolicySet, (String)"PolicyCombiningAlgId", (!bLenient ? 1 : 0) != 0);
                    combiningAlgorithm = null;
                    try {
                        combiningAlgorithm = CombiningAlgorithmFactory.newInstance().getPolicyCombiningAlgorithm(identifier);
                    }
                    catch (FactoryException ex) {
                        if (bLenient) break block30;
                        throw new DOMStructureException("Failed to get CombinginAlgorithm", (Throwable)ex);
                    }
                }
                if (combiningAlgorithm == null && !bLenient) {
                    throw new DOMStructureException((Node)elementPolicySet, "Unknown policy combining algorithm \"" + identifier.toString() + "\" in \"" + DOMUtil.getNodeLabel((Node)nodePolicySet));
                }
                domPolicySet.setPolicyCombiningAlgorithm(combiningAlgorithm);
                Integer integer = DOMUtil.getIntegerAttribute((Node)elementPolicySet, (String)"MaxDelegationDepth");
                if (integer != null) {
                    domPolicySet.setMaxDelegationDepth(integer);
                }
            }
            catch (DOMStructureException ex) {
                domPolicySet.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block31;
                throw ex;
            }
        }
        return domPolicySet;
    }

    public static boolean repair(Node nodePolicySet) throws DOMStructureException {
        int numChildren;
        Element elementPolicySet = DOMUtil.getElement((Node)nodePolicySet);
        boolean result = false;
        NodeList children = elementPolicySet.getChildNodes();
        boolean sawDescription = false;
        boolean sawPolicyIssuer = false;
        boolean sawPolicyDefaults = false;
        boolean sawTarget = false;
        boolean sawObligationExprs = false;
        boolean sawAdviceExprs = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("Description".equals(childName)) {
                        if (sawDescription) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementPolicySet.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawDescription = true;
                        continue;
                    }
                    if ("PolicyIssuer".equals(childName)) {
                        if (sawPolicyIssuer) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementPolicySet.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawPolicyIssuer = true;
                        result = DOMPolicyIssuer.repair(child) || result;
                        continue;
                    }
                    if ("PolicySetDefaults".equals(childName)) {
                        if (sawPolicyDefaults) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementPolicySet.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawPolicyDefaults = true;
                        result = DOMPolicyDefaults.repair(child) || result;
                        continue;
                    }
                    if ("Target".equals(childName)) {
                        if (sawTarget) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementPolicySet.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawTarget = true;
                        result = DOMTarget.repair(child) || result;
                        continue;
                    }
                    if ("PolicySet".equals(childName)) {
                        result = DOMPolicySet.repair(child) || result;
                        continue;
                    }
                    if ("Policy".equals(childName)) {
                        result = DOMPolicy.repair(child) || result;
                        continue;
                    }
                    if ("PolicyIdReference".equals(childName)) {
                        result = DOMPolicyIdReference.repair(child) || result;
                        continue;
                    }
                    if ("PolicySetIdReference".equals(childName)) {
                        result = DOMPolicySetIdReference.repair(child) || result;
                        continue;
                    }
                    if ("CombinerParameters".equals(childName)) {
                        result = DOMCombinerParameter.repair(child) || result;
                        continue;
                    }
                    if ("PolicyCombinerParameters".equals(childName)) {
                        result = DOMPolicyCombinerParameter.repair(child) || result;
                        continue;
                    }
                    if ("PolicySetCombinerParameters".equals(childName)) {
                        result = DOMPolicySetCombinerParameter.repair(child) || result;
                        continue;
                    }
                    if ("ObligationExpressions".equals(childName)) {
                        if (sawObligationExprs) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementPolicySet.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawObligationExprs = true;
                        result = DOMObligationExpression.repairList(child) || result;
                        continue;
                    }
                    if ("AdviceExpressions".equals(childName)) {
                        if (sawAdviceExprs) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementPolicySet.removeChild(child);
                            result = true;
                            continue;
                        }
                        sawAdviceExprs = true;
                        result = DOMAdviceExpression.repairList(child) || result;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementPolicySet.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementPolicySet.removeChild(child);
                result = true;
            }
        }
        if (!sawTarget) {
            throw DOMUtil.newMissingElementException((Node)nodePolicySet, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"Target");
        }
        result = DOMUtil.repairIdentifierAttribute((Element)elementPolicySet, (String)"PolicySetId", (Log)logger) || result;
        result = DOMUtil.repairVersionAttribute((Element)elementPolicySet, (String)"Version", (Log)logger) || result;
        result = DOMUtil.repairIdentifierAttribute((Element)elementPolicySet, (String)"PolicyCombiningAlgId", (Identifier)XACML3.ID_POLICY_DENY_OVERRIDES, (Log)logger) || result;
        Identifier identifier = DOMUtil.getIdentifierAttribute((Node)elementPolicySet, (String)"PolicyCombiningAlgId");
        CombiningAlgorithm<PolicySetChild> combiningAlgorithm = null;
        try {
            combiningAlgorithm = CombiningAlgorithmFactory.newInstance().getPolicyCombiningAlgorithm(identifier);
        }
        catch (FactoryException ex) {
            combiningAlgorithm = null;
        }
        if (combiningAlgorithm == null) {
            logger.warn((Object)("Setting invalid PolicyCombiningAlgId attribute " + identifier.stringValue() + " to " + XACML3.ID_POLICY_DENY_OVERRIDES.stringValue()));
            elementPolicySet.setAttribute("PolicyCombiningAlgId", XACML3.ID_POLICY_DENY_OVERRIDES.stringValue());
            result = true;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            for (String fileName : args) {
                File filePolicy = new File(fileName);
                if (filePolicy.exists() && filePolicy.canRead()) {
                    try {
                        Document documentPolicy = DOMUtil.loadDocument((File)filePolicy);
                        if (documentPolicy.getFirstChild() == null) {
                            System.err.println(fileName + ": Error: No PolicySet found");
                            continue;
                        }
                        if (!"PolicySet".equals(documentPolicy.getFirstChild().getLocalName())) {
                            System.err.println(fileName + ": Error: Not a PolicySet document");
                            continue;
                        }
                        PolicySet policySet = DOMPolicySet.newInstance(documentPolicy.getFirstChild(), null, null);
                        System.out.println(fileName + ": validate()=" + policySet.validate());
                        System.out.println(StringUtils.prettyPrint((String)policySet.toString()));
                    }
                    catch (Exception ex) {
                        System.err.println("Exception processing policy set file \"" + fileName + "\"");
                        ex.printStackTrace(System.err);
                    }
                    continue;
                }
                System.err.println("Cannot read policy set file \"" + fileName + "\"");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

