/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.Expression;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.policy.FunctionArgumentExpression;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinition;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinitionFactory;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.util.FactoryException;

public class Apply
extends Expression {
    private Identifier functionId;
    private FunctionDefinition functionDefinition;
    private String description;
    private List<Expression> arguments = new ArrayList<Expression>();

    protected List<Expression> getArgumentList() {
        return this.arguments;
    }

    protected void clearArgumentList() {
        this.getArgumentList().clear();
    }

    public Apply(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public Apply(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public Apply() {
    }

    public Apply(Identifier functionIdIn, String descriptionIn, Collection<Expression> argumentsIn) {
        this.functionId = functionIdIn;
        this.description = descriptionIn;
        if (argumentsIn != null) {
            this.arguments.addAll(argumentsIn);
        }
    }

    public Identifier getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(Identifier identifier) {
        this.functionId = identifier;
        this.functionDefinition = null;
    }

    public FunctionDefinition getFunctionDefinition() {
        Identifier thisFunctionId;
        if (this.functionDefinition == null && (thisFunctionId = this.getFunctionId()) != null) {
            try {
                this.functionDefinition = FunctionDefinitionFactory.newInstance().getFunctionDefinition(thisFunctionId);
            }
            catch (FactoryException ex) {
                this.setStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "FactoryException getting FunctionDefinition");
            }
        }
        return this.functionDefinition;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Iterator<Expression> getArguments() {
        return this.getArgumentList().iterator();
    }

    public void setArguments(Collection<Expression> listExpressions) {
        this.clearArgumentList();
        if (listExpressions != null) {
            this.addArguments(listExpressions);
        }
    }

    public void addArgument(Expression expression) {
        this.getArgumentList().add(expression);
    }

    public void addArguments(Collection<Expression> listExpressions) {
        this.getArgumentList().addAll(listExpressions);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return ExpressionResult.newError((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        FunctionDefinition thisFunctionDefinition = this.getFunctionDefinition();
        if (thisFunctionDefinition == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Unknown Function \"" + this.getFunctionId().toString() + "\""));
        }
        ArrayList<FunctionArgument> listFunctionArguments = new ArrayList<FunctionArgument>();
        Iterator<Expression> iterExpressionArguments = this.getArguments();
        if (iterExpressionArguments != null) {
            while (iterExpressionArguments.hasNext()) {
                listFunctionArguments.add(new FunctionArgumentExpression(iterExpressionArguments.next(), evaluationContext, policyDefaults));
            }
        }
        return thisFunctionDefinition.evaluate(evaluationContext, listFunctionArguments);
    }

    @Override
    protected boolean validateComponent() {
        if (this.getFunctionId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing FunctionId");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }
}

