/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.IdReferenceMatch;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.api.trace.TraceEngine;
import org.apache.openaz.xacml.api.trace.TraceEngineFactory;
import org.apache.openaz.xacml.api.trace.TraceEvent;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicyFinder;
import org.apache.openaz.xacml.pdp.policy.PolicyFinderResult;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.std.pip.engines.RequestEngine;
import org.apache.openaz.xacml.std.pip.finders.RequestFinder;
import org.apache.openaz.xacml.util.FactoryException;

public class StdEvaluationContext
implements EvaluationContext {
    private Log logger = LogFactory.getLog(this.getClass());
    private Request request;
    private RequestFinder requestFinder;
    private PolicyFinder policyFinder;
    private TraceEngine traceEngine;

    public StdEvaluationContext(Request requestIn, PolicyFinder policyFinderIn, PIPFinder pipFinder, TraceEngine traceEngineIn) {
        this.request = requestIn;
        this.policyFinder = policyFinderIn;
        if (traceEngineIn != null) {
            this.traceEngine = traceEngineIn;
        } else {
            try {
                this.traceEngine = TraceEngineFactory.newInstance().getTraceEngine();
            }
            catch (FactoryException ex) {
                this.logger.error((Object)("FactoryException creating TraceEngine: " + ex.toString()), (Throwable)ex);
            }
        }
        this.requestFinder = pipFinder == null ? new RequestFinder(null, new RequestEngine(requestIn)) : (pipFinder instanceof RequestFinder ? (RequestFinder)pipFinder : new RequestFinder(pipFinder, new RequestEngine(requestIn)));
    }

    public StdEvaluationContext(Request requestIn, PolicyFinder policyFinderIn, PIPFinder pipFinder) {
        this(requestIn, policyFinderIn, pipFinder, null);
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest) throws PIPException {
        return this.requestFinder.getAttributes(pipRequest, null);
    }

    public PIPResponse getAttributes(PIPRequest pipRequest, PIPEngine exclude) throws PIPException {
        return this.requestFinder.getAttributes(pipRequest, exclude);
    }

    public PIPResponse getAttributes(PIPRequest pipRequest, PIPEngine exclude, PIPFinder pipFinderRoot) throws PIPException {
        return this.requestFinder.getAttributes(pipRequest, exclude, pipFinderRoot);
    }

    @Override
    public PolicyFinderResult<PolicyDef> getRootPolicyDef() {
        return this.policyFinder.getRootPolicyDef(this);
    }

    @Override
    public PolicyFinderResult<Policy> getPolicy(IdReferenceMatch idReferenceMatch) {
        return this.policyFinder.getPolicy(idReferenceMatch);
    }

    @Override
    public PolicyFinderResult<PolicySet> getPolicySet(IdReferenceMatch idReferenceMatch) {
        return this.policyFinder.getPolicySet(idReferenceMatch);
    }

    public void trace(TraceEvent<?> traceEvent) {
        if (this.traceEngine != null) {
            this.traceEngine.trace(traceEvent);
        }
    }

    public boolean isTracing() {
        return this.traceEngine == null ? false : this.traceEngine.isTracing();
    }

    public PIPResponse getMatchingAttributes(PIPRequest pipRequest, PIPEngine exclude) throws PIPException {
        return this.requestFinder.getMatchingAttributes(pipRequest, exclude);
    }

    public PIPResponse getMatchingAttributes(PIPRequest pipRequest, PIPEngine exclude, PIPFinder pipFinderParent) throws PIPException {
        return this.requestFinder.getMatchingAttributes(pipRequest, exclude, pipFinderParent);
    }

    public Collection<PIPEngine> getPIPEngines() {
        return this.requestFinder.getPIPEngines();
    }
}

