/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.combiners;

import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.Evaluatable;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.pdp.policy.CombiningElement;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.std.combiners.CombiningAlgorithmBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public class OnlyOneApplicable
extends CombiningAlgorithmBase<PolicySetChild> {
    public OnlyOneApplicable(Identifier identifierIn) {
        super(identifierIn);
    }

    @Override
    public EvaluationResult combine(EvaluationContext evaluationContext, List<CombiningElement<PolicySetChild>> elements, List<CombinerParameter> combinerParameters) throws EvaluationException {
        Iterator<CombiningElement<PolicySetChild>> iterElements = elements.iterator();
        Evaluatable policySetChildApplicable = null;
        block5: while (iterElements.hasNext()) {
            CombiningElement<PolicySetChild> combiningElement = iterElements.next();
            MatchResult matchResultElement = combiningElement.getEvaluatable().match(evaluationContext);
            switch (matchResultElement.getMatchCode()) {
                case INDETERMINATE: {
                    return new EvaluationResult(Decision.INDETERMINATE, matchResultElement.getStatus());
                }
                case MATCH: {
                    if (policySetChildApplicable == null) {
                        policySetChildApplicable = combiningElement.getEvaluatable();
                        continue block5;
                    }
                    return new EvaluationResult(Decision.INDETERMINATE, (Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "More than one applicable policy"));
                }
                case NOMATCH: {
                    continue block5;
                }
            }
            throw new EvaluationException("Illegal Decision: \"" + matchResultElement.getMatchCode().toString());
        }
        if (policySetChildApplicable != null) {
            return policySetChildApplicable.evaluate(evaluationContext);
        }
        return new EvaluationResult(Decision.NOTAPPLICABLE);
    }
}

