/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public class ConvertedArgument<I> {
    private Status status;
    private I value = null;

    public ConvertedArgument(Status s, I v) {
        this.status = s;
        if (s == null) {
            throw new IllegalArgumentException("Status of argument cannot be null");
        }
        if (s.isOk()) {
            this.value = v;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status.isOk();
    }

    public I getValue() {
        return this.value;
    }

    public Bag getBag() {
        return (Bag)this.value;
    }

    public String getShortDataTypeId(Identifier identifier) {
        String idString = identifier.stringValue();
        int index = idString.indexOf("#");
        if (index < 0) {
            index = idString.indexOf(":data-type:");
            if (index < 0) {
                return idString;
            }
            return idString.substring(index + 11);
        }
        return idString.substring(index + 1);
    }

    public ConvertedArgument(FunctionArgument functionArgument, DataType<I> expectedDataType, boolean expectBag) {
        if (functionArgument == null) {
            this.status = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Got null argument");
            return;
        }
        if (!functionArgument.isOk()) {
            this.status = functionArgument.getStatus();
            return;
        }
        if (expectBag) {
            if (!functionArgument.isBag()) {
                this.status = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Expected a bag, saw a simple value");
                return;
            }
            Bag bag = functionArgument.getBag();
            this.value = bag;
            this.status = StdStatus.STATUS_OK;
            return;
        }
        if (functionArgument.isBag()) {
            this.status = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Expected a simple value, saw a bag");
            return;
        }
        AttributeValue<?> attributeValue = functionArgument.getValue();
        if (attributeValue == null || attributeValue.getValue() == null) {
            this.status = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Got null attribute");
            return;
        }
        if (!attributeValue.getDataTypeId().equals((Object)expectedDataType.getId())) {
            this.status = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Expected data type '" + this.getShortDataTypeId(expectedDataType.getId()) + "' saw '" + this.getShortDataTypeId(attributeValue.getDataTypeId()) + "'");
            return;
        }
        try {
            this.value = expectedDataType.convert(attributeValue.getValue());
            this.status = StdStatus.STATUS_OK;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            this.status = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, message);
        }
    }
}

