/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.List;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionRegexpMatch<I>
extends FunctionDefinitionBase<Boolean, I> {
    public FunctionDefinitionRegexpMatch(Identifier idIn, DataType<I> dataTypeArgsIn) {
        super(idIn, DataTypes.DT_BOOLEAN, dataTypeArgsIn, false);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        String elementValueString;
        if (arguments == null || arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 2 arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        FunctionArgument regexpArgument = arguments.get(0);
        ConvertedArgument convertedArgument = new ConvertedArgument(regexpArgument, DataTypes.DT_STRING, false);
        if (!convertedArgument.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedArgument.getStatus()));
        }
        String regexpValue = (String)convertedArgument.getValue();
        FunctionArgument elementArgument = arguments.get(1);
        ConvertedArgument convertedElement = new ConvertedArgument(elementArgument, this.getDataTypeArgs(), false);
        if (!convertedElement.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedElement.getStatus()));
        }
        Object elementValueObject = convertedElement.getValue();
        try {
            elementValueString = this.getDataTypeArgs().toStringValue(elementValueObject);
        }
        catch (DataTypeException e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
        }
        if (elementValueString.matches(regexpValue)) {
            return ER_TRUE;
        }
        return ER_FALSE;
    }
}

