/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public class FunctionDefinitionSet<O, I>
extends FunctionDefinitionBase<O, I> {
    private OPERATION operation;

    public FunctionDefinitionSet(Identifier idIn, DataType<O> dataTypeIn, DataType<I> dataTypeArgsIn, OPERATION opIn) {
        super(idIn, dataTypeIn, dataTypeArgsIn, opIn == OPERATION.INTERSECTION || opIn == OPERATION.UNION);
        this.operation = opIn;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        if (arguments == null || arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 2 arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        FunctionArgument bagArgument = arguments.get(0);
        ConvertedArgument convertedBagArgument = new ConvertedArgument(bagArgument, null, true);
        if (!convertedBagArgument.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedBagArgument.getStatus()));
        }
        Bag bag1 = convertedBagArgument.getBag();
        List<AttributeValue<?>> list1 = bag1.getAttributeValueList();
        bagArgument = arguments.get(1);
        convertedBagArgument = new ConvertedArgument(bagArgument, null, true);
        if (!convertedBagArgument.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedBagArgument.getStatus()));
        }
        Bag bag2 = convertedBagArgument.getBag();
        List<AttributeValue<?>> list2 = bag2.getAttributeValueList();
        ExpressionResult expressionResult = null;
        switch (this.operation) {
            case INTERSECTION: {
                ArrayList outList = new ArrayList();
                for (AttributeValue<?> attributeValue : list1) {
                    if (outList.contains(attributeValue) || !list2.contains(attributeValue)) continue;
                    outList.add(attributeValue);
                }
                Bag outBag = new Bag();
                for (AttributeValue attributeValue : outList) {
                    outBag.add(attributeValue);
                }
                expressionResult = ExpressionResult.newBag(outBag);
                return expressionResult;
            }
            case AT_LEAST_ONE_MEMBER_OF: {
                for (AttributeValue<?> attributeValue : list1) {
                    if (!list2.contains(attributeValue)) continue;
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case UNION: {
                ArrayList outList = new ArrayList();
                for (AttributeValue<?> attributeValue : list1) {
                    if (outList.contains(attributeValue)) continue;
                    outList.add(attributeValue);
                }
                for (AttributeValue<?> attributeValue : list2) {
                    if (outList.contains(attributeValue)) continue;
                    outList.add(attributeValue);
                }
                Bag outBag = new Bag();
                for (AttributeValue attributeValue : outList) {
                    outBag.add(attributeValue);
                }
                expressionResult = ExpressionResult.newBag(outBag);
                return expressionResult;
            }
            case SUBSET: {
                for (AttributeValue<?> attributeValue : list1) {
                    if (list2.contains(attributeValue)) continue;
                    return ER_FALSE;
                }
                return ER_TRUE;
            }
            case SET_EQUALS: {
                for (AttributeValue<?> attributeValue : list1) {
                    if (list2.contains(attributeValue)) continue;
                    return ER_FALSE;
                }
                for (AttributeValue<?> attributeValue : list2) {
                    if (list1.contains(attributeValue)) continue;
                    return ER_FALSE;
                }
                return ER_TRUE;
            }
        }
        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Could not evaluate Set function " + (Object)((Object)this.operation)));
    }

    public static enum OPERATION {
        INTERSECTION,
        AT_LEAST_ONE_MEMBER_OF,
        UNION,
        SUBSET,
        SET_EQUALS;

    }
}

