/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.net.URI;
import java.util.List;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

@Deprecated
public class FunctionDefinitionURIStringConcatenate
extends FunctionDefinitionBase<URI, URI> {
    public FunctionDefinitionURIStringConcatenate(Identifier idIn) {
        super(idIn, DataTypes.DT_ANYURI, DataTypes.DT_ANYURI, false);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        int i;
        if (arguments == null || arguments.size() < 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 2 or more arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        ConvertedArgument uriArgument = new ConvertedArgument(arguments.get(0), DataTypes.DT_ANYURI, false);
        if (!uriArgument.isOk()) {
            StdStatus decoratedStatus = new StdStatus(uriArgument.getStatus().getStatusCode(), uriArgument.getStatus().getStatusMessage() + " at arg index 0");
            return ExpressionResult.newError(this.getFunctionStatus((Status)decoratedStatus));
        }
        String uriString = ((URI)uriArgument.getValue()).toString();
        String[] stringValues = new String[arguments.size() - 1];
        for (i = 1; i < arguments.size(); ++i) {
            ConvertedArgument stringArgument = new ConvertedArgument(arguments.get(i), DataTypes.DT_STRING, false);
            if (!stringArgument.isOk()) {
                StdStatus decoratedStatus = new StdStatus(stringArgument.getStatus().getStatusCode(), stringArgument.getStatus().getStatusMessage() + " at arg index " + i);
                return ExpressionResult.newError(this.getFunctionStatus((Status)decoratedStatus));
            }
            stringValues[i - 1] = (String)stringArgument.getValue();
        }
        for (i = 0; i < stringValues.length; ++i) {
            uriString = uriString + stringValues[i];
        }
        URI resultURI = null;
        try {
            resultURI = DataTypes.DT_ANYURI.convert((Object)uriString);
        }
        catch (DataTypeException e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, this.getShortFunctionId() + " Final string '" + uriString + "' not URI, " + message));
        }
        return ExpressionResult.newSingle(new StdAttributeValue(XACML.ID_DATATYPE_ANYURI, (Object)resultURI));
    }
}

