/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.eval.Matchable;
import org.apache.openaz.xacml.pdp.policy.Match;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.util.StringUtils;

public class AllOf
extends PolicyComponent
implements Matchable {
    private List<Match> matches;

    protected List<Match> getMatchList(boolean bNoNulls) {
        if (this.matches == null && bNoNulls) {
            this.matches = new ArrayList<Match>();
        }
        return this.matches;
    }

    protected void clearMatchList() {
        if (this.matches != null) {
            this.matches.clear();
        }
    }

    public AllOf(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public AllOf(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public AllOf() {
    }

    public Iterator<Match> getMatches() {
        return this.matches == null ? null : this.matches.iterator();
    }

    public void setMatches(Collection<Match> matchesIn) {
        this.clearMatchList();
        if (matchesIn != null) {
            this.addMatches(matchesIn);
        }
    }

    public void addMatch(Match match) {
        List<Match> matchList = this.getMatchList(true);
        matchList.add(match);
    }

    public void addMatches(Collection<Match> matchesIn) {
        List<Match> matchList = this.getMatchList(true);
        matchList.addAll(matchesIn);
    }

    @Override
    public MatchResult match(EvaluationContext evaluationContext) throws EvaluationException {
        if (!this.validate()) {
            return new MatchResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        Iterator<Match> iterMatches = this.getMatches();
        assert (iterMatches != null && iterMatches.hasNext());
        MatchResult matchResultFallThrough = MatchResult.MM_MATCH;
        while (iterMatches.hasNext()) {
            MatchResult matchResultMatch = iterMatches.next().match(evaluationContext);
            assert (matchResultMatch != null);
            switch (matchResultMatch.getMatchCode()) {
                case INDETERMINATE: {
                    if (matchResultFallThrough.getMatchCode() == MatchResult.MatchCode.INDETERMINATE) break;
                    matchResultFallThrough = matchResultMatch;
                    break;
                }
                case MATCH: {
                    matchResultFallThrough = matchResultFallThrough.addMatchedAttributeCategory(matchResultMatch.getMatchedAttributeCategories());
                    break;
                }
                case NOMATCH: {
                    return matchResultMatch;
                }
            }
        }
        return matchResultFallThrough;
    }

    @Override
    protected boolean validateComponent() {
        Iterator<Match> iterMatches = this.getMatches();
        if (iterMatches == null || !iterMatches.hasNext()) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing matches");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        String stringMatches = StringUtils.toString(this.getMatches());
        if (stringMatches != null) {
            stringBuilder.append(",matches=");
            stringBuilder.append(stringMatches);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

