/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.openaz.xacml.api.AttributeAssignment;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.AttributeAssignmentResult;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.Expression;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.std.StdMutableAttributeAssignment;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public class AttributeAssignmentExpression
extends PolicyComponent {
    private static final AttributeAssignmentResult AAR_NULL_EXPRESSION = new AttributeAssignmentResult((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Null expression"));
    private static final AttributeAssignmentResult AAR_NULL_EXPRESSION_RESULT = new AttributeAssignmentResult((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Null expression result"));
    private Expression expression;
    private Identifier attributeId;
    private Identifier category;
    private String issuer;

    public AttributeAssignmentExpression(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public AttributeAssignmentExpression(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public AttributeAssignmentExpression() {
    }

    public AttributeAssignmentExpression(Identifier categoryIn, Identifier attributeIdIn, String issuerIn, Expression expressionIn) {
        this.category = categoryIn;
        this.attributeId = attributeIdIn;
        this.issuer = issuerIn;
        this.expression = expressionIn;
    }

    public Identifier getCategory() {
        return this.category;
    }

    public void setCategory(Identifier identifier) {
        this.category = identifier;
    }

    public Identifier getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(Identifier identifier) {
        this.attributeId = identifier;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String string) {
        this.issuer = string;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expressionIn) {
        this.expression = expressionIn;
    }

    public AttributeAssignmentResult evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return new AttributeAssignmentResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        Expression thisExpression = this.getExpression();
        if (thisExpression == null) {
            return AAR_NULL_EXPRESSION;
        }
        ExpressionResult thisExpressionResult = thisExpression.evaluate(evaluationContext, policyDefaults);
        if (thisExpressionResult == null) {
            return AAR_NULL_EXPRESSION_RESULT;
        }
        if (!thisExpressionResult.isOk()) {
            return new AttributeAssignmentResult(thisExpressionResult.getStatus());
        }
        ArrayList<AttributeAssignment> listAttributeAssignments = new ArrayList<AttributeAssignment>();
        if (thisExpressionResult.isBag()) {
            Bag bagValues = thisExpressionResult.getBag();
            if (bagValues == null || bagValues.size() == 0) {
                listAttributeAssignments.add((AttributeAssignment)new StdMutableAttributeAssignment(this.getCategory(), this.getAttributeId(), this.getIssuer(), null));
            } else {
                Iterator<AttributeValue<?>> iterBagValues = bagValues.getAttributeValues();
                while (iterBagValues.hasNext()) {
                    AttributeValue<?> attributeValue = iterBagValues.next();
                    listAttributeAssignments.add((AttributeAssignment)new StdMutableAttributeAssignment(this.getCategory(), this.getAttributeId(), this.getIssuer(), attributeValue));
                }
            }
        } else {
            listAttributeAssignments.add((AttributeAssignment)new StdMutableAttributeAssignment(this.getCategory(), this.getAttributeId(), this.getIssuer(), thisExpressionResult.getValue()));
        }
        return new AttributeAssignmentResult(listAttributeAssignments);
    }

    @Override
    protected boolean validateComponent() {
        if (this.getAttributeId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AttributeId");
            return false;
        }
        if (this.getExpression() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing Expression");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getCategory();
        if (objectToDump != null) {
            stringBuilder.append(",category=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getAttributeId()) != null) {
            stringBuilder.append(",attributeId=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getExpression()) != null) {
            stringBuilder.append(",expression=");
            stringBuilder.append(objectToDump.toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

