/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.Expression;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.ExpressionResultBoolean;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class Condition
extends PolicyComponent {
    private static final Status STATUS_PE_RETURNED_BAG = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Condition Expression returned a bag");
    private static final ExpressionResultBoolean ERB_RETURNED_BAG = new ExpressionResultBoolean(STATUS_PE_RETURNED_BAG);
    private static final Status STATUS_PE_RETURNED_NULL = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Null value from Condition Expression");
    private static final ExpressionResultBoolean ERB_RETURNED_NULL = new ExpressionResultBoolean(STATUS_PE_RETURNED_NULL);
    private static final Status STATUS_PE_RETURNED_NON_BOOLEAN = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Non-boolean value from Condition Expression");
    private static final ExpressionResultBoolean ERB_RETURNED_NON_BOOLEAN = new ExpressionResultBoolean(STATUS_PE_RETURNED_NON_BOOLEAN);
    private static final Status STATUS_PE_INVALID_BOOLEAN = new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Invalid Boolean value");
    private static final ExpressionResultBoolean ERB_INVALID_BOOLEAN = new ExpressionResultBoolean(STATUS_PE_INVALID_BOOLEAN);
    private Expression expression;

    public Condition(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public Condition(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public Condition() {
    }

    public Condition(Expression expressionIn) {
        this.expression = expressionIn;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expressionIn) {
        this.expression = expressionIn;
    }

    @Override
    protected boolean validateComponent() {
        if (this.getExpression() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing Expression");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }

    public ExpressionResultBoolean evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return new ExpressionResultBoolean((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        ExpressionResult expressionResult = this.getExpression().evaluate(evaluationContext, policyDefaults);
        assert (expressionResult != null);
        if (!expressionResult.isOk()) {
            return new ExpressionResultBoolean(expressionResult.getStatus());
        }
        if (expressionResult.isBag()) {
            return ERB_RETURNED_BAG;
        }
        AttributeValue<?> attributeValueResult = expressionResult.getValue();
        if (attributeValueResult == null) {
            return ERB_RETURNED_NULL;
        }
        if (!DataTypes.DT_BOOLEAN.getId().equals((Object)attributeValueResult.getDataTypeId())) {
            return ERB_RETURNED_NON_BOOLEAN;
        }
        Boolean booleanValue = null;
        try {
            booleanValue = DataTypes.DT_BOOLEAN.convert(attributeValueResult.getValue());
        }
        catch (DataTypeException ex) {
            return new ExpressionResultBoolean((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, ex.getMessage()));
        }
        if (booleanValue == null) {
            return ERB_INVALID_BOOLEAN;
        }
        return booleanValue != false ? ExpressionResultBoolean.ERB_TRUE : ExpressionResultBoolean.ERB_FALSE;
    }
}

