/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeAssignment;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.AttributeAssignmentExpression;
import org.apache.openaz.xacml.pdp.policy.AttributeAssignmentResult;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.RuleEffect;
import org.apache.openaz.xacml.std.StdMutableObligation;
import org.apache.openaz.xacml.std.StdStatusCode;

public class ObligationExpression
extends PolicyComponent {
    private Identifier obligationId;
    private RuleEffect ruleEffect;
    private List<AttributeAssignmentExpression> attributeAssignmentExpressions;

    protected List<AttributeAssignmentExpression> getAttributeAssignmentExpressionList(boolean bNoNull) {
        if (this.attributeAssignmentExpressions == null && bNoNull) {
            this.attributeAssignmentExpressions = new ArrayList<AttributeAssignmentExpression>();
        }
        return this.attributeAssignmentExpressions;
    }

    protected void clearAttributeAssignmentExpressions() {
        if (this.attributeAssignmentExpressions != null) {
            this.attributeAssignmentExpressions.clear();
        }
    }

    public ObligationExpression(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public ObligationExpression(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public ObligationExpression() {
    }

    public Identifier getObligationId() {
        return this.obligationId;
    }

    public void setObligationId(Identifier identifier) {
        this.obligationId = identifier;
    }

    public RuleEffect getRuleEffect() {
        return this.ruleEffect;
    }

    public void setRuleEffect(RuleEffect ruleEffectIn) {
        this.ruleEffect = ruleEffectIn;
    }

    public Iterator<AttributeAssignmentExpression> getAttributeAssignmentExpressions() {
        List<AttributeAssignmentExpression> listAttributeAssignmentExpressions = this.getAttributeAssignmentExpressionList(false);
        return listAttributeAssignmentExpressions == null ? null : listAttributeAssignmentExpressions.iterator();
    }

    public void setAttributeAssignmentExpressions(Collection<AttributeAssignmentExpression> attributeAssignmentExpressionsIn) {
        this.clearAttributeAssignmentExpressions();
        if (attributeAssignmentExpressionsIn != null) {
            this.addAttributeAssignmentExpressions(attributeAssignmentExpressionsIn);
        }
    }

    public void addAttributeAssignmentExpression(AttributeAssignmentExpression attributeAssignmentExpression) {
        List<AttributeAssignmentExpression> listAttributeAssignmentExpressions = this.getAttributeAssignmentExpressionList(true);
        listAttributeAssignmentExpressions.add(attributeAssignmentExpression);
    }

    public void addAttributeAssignmentExpressions(Collection<AttributeAssignmentExpression> attributeAssignmentExpressionsIn) {
        List<AttributeAssignmentExpression> listAttributeAssignmentExpressions = this.getAttributeAssignmentExpressionList(true);
        listAttributeAssignmentExpressions.addAll(attributeAssignmentExpressionsIn);
    }

    public Obligation evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return null;
        }
        ArrayList<AttributeAssignment> listAttributeAssignments = new ArrayList<AttributeAssignment>();
        Iterator<AttributeAssignmentExpression> iterAttributeAssignmentExpressions = this.getAttributeAssignmentExpressions();
        if (iterAttributeAssignmentExpressions != null) {
            while (iterAttributeAssignmentExpressions.hasNext()) {
                AttributeAssignmentResult attributeAssignmentResult = iterAttributeAssignmentExpressions.next().evaluate(evaluationContext, policyDefaults);
                if (!attributeAssignmentResult.isOk() || attributeAssignmentResult.getNumAttributeAssignments() <= 0) continue;
                Iterator<AttributeAssignment> iterAttributeAssignments = attributeAssignmentResult.getAttributeAssignments();
                while (iterAttributeAssignments.hasNext()) {
                    listAttributeAssignments.add(iterAttributeAssignments.next());
                }
            }
        }
        return new StdMutableObligation(this.getObligationId(), listAttributeAssignments);
    }

    public static List<Obligation> evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults, Decision decision, Collection<ObligationExpression> listObligationExpressions) throws EvaluationException {
        ArrayList<Obligation> listObligations = new ArrayList<Obligation>();
        for (ObligationExpression obligationExpression : listObligationExpressions) {
            Obligation obligation;
            obligationExpression.validateComponent();
            if (!obligationExpression.isOk()) {
                throw new EvaluationException(obligationExpression.getStatusMessage());
            }
            if (decision != null && !obligationExpression.getRuleEffect().getDecision().equals((Object)decision) || (obligation = obligationExpression.evaluate(evaluationContext, policyDefaults)) == null) continue;
            listObligations.add(obligation);
        }
        return listObligations;
    }

    @Override
    protected boolean validateComponent() {
        if (this.getObligationId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing ObligationId attribute");
            return false;
        }
        if (this.getRuleEffect() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing FulfillOn attribute");
            return false;
        }
        this.setStatus(StdStatusCode.STATUS_CODE_OK, null);
        return true;
    }
}

