/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.IdReferenceMatch;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.Version;
import org.apache.openaz.xacml.api.VersionMatch;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.policy.AdviceExpression;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.pdp.policy.ObligationExpression;
import org.apache.openaz.xacml.pdp.policy.PolicyIssuer;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.Target;
import org.apache.openaz.xacml.std.StdIdReference;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.util.StringUtils;

public abstract class PolicyDef
extends PolicySetChild {
    private String description;
    private PolicyIssuer policyIssuer;
    private Target target;
    private List<CombinerParameter> combinerParameters;
    private List<ObligationExpression> obligationExpressions;
    private List<AdviceExpression> adviceExpressions;
    private Version version;
    private Integer maxDelegationDepth;
    private IdReference idReference;

    private void ensureCombinerParameters() {
        if (this.combinerParameters == null) {
            this.combinerParameters = new ArrayList<CombinerParameter>();
        }
    }

    private void ensureObligationExpressions() {
        if (this.obligationExpressions == null) {
            this.obligationExpressions = new ArrayList<ObligationExpression>();
        }
    }

    private void ensureAdviceExpressions() {
        if (this.adviceExpressions == null) {
            this.adviceExpressions = new ArrayList<AdviceExpression>();
        }
    }

    protected List<CombinerParameter> getCombinerParameterList() {
        return this.combinerParameters;
    }

    protected List<ObligationExpression> getObligationExpressionList() {
        return this.obligationExpressions;
    }

    protected List<AdviceExpression> getAdviceExpressionList() {
        return this.adviceExpressions;
    }

    protected void updateResult(EvaluationResult evaluationResult, EvaluationContext evaluationContext) throws EvaluationException {
        List<Advice> listAdvices;
        List<AdviceExpression> thisAdviceExpressions;
        List<Obligation> listObligations;
        List<ObligationExpression> thisObligationExpressions = this.getObligationExpressionList();
        if (thisObligationExpressions != null && thisObligationExpressions.size() > 0 && (listObligations = ObligationExpression.evaluate(evaluationContext, this.getPolicyDefaults(), evaluationResult.getDecision(), thisObligationExpressions)) != null && listObligations.size() > 0) {
            evaluationResult.addObligations(listObligations);
        }
        if ((thisAdviceExpressions = this.getAdviceExpressionList()) != null && thisAdviceExpressions.size() > 0 && (listAdvices = AdviceExpression.evaluate(evaluationContext, this.getPolicyDefaults(), evaluationResult.getDecision(), thisAdviceExpressions)) != null && listAdvices.size() > 0) {
            evaluationResult.addAdvice(listAdvices);
        }
    }

    @Override
    protected boolean validateComponent() {
        if (super.validateComponent()) {
            if (this.getVersion() == null) {
                this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing version string");
                return false;
            }
            if (this.getTarget() == null) {
                this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing Target in policy " + this.getIdReference().getId().stringValue());
                return false;
            }
            return true;
        }
        return false;
    }

    public PolicyDef(PolicySet policySetParent, StatusCode statusCodeIn, String statusMessageIn) {
        super(policySetParent, statusCodeIn, statusMessageIn);
    }

    public PolicyDef(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public PolicyDef(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public PolicyDef(PolicySet policySetParent) {
        super(policySetParent);
    }

    public PolicyDef() {
    }

    @Override
    public void setIdentifier(Identifier identifierIn) {
        super.setIdentifier(identifierIn);
        this.idReference = null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public PolicyIssuer getPolicyIssuer() {
        return this.policyIssuer;
    }

    public void setPolicyIssuer(PolicyIssuer policyIssuerIn) {
        this.policyIssuer = policyIssuerIn;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target targetIn) {
        this.target = targetIn;
    }

    public Iterator<CombinerParameter> getCombinerParameters() {
        return this.combinerParameters == null ? null : this.combinerParameters.iterator();
    }

    public void setCombinerParameters(Collection<CombinerParameter> combinerParametersIn) {
        this.combinerParameters = null;
        if (combinerParametersIn != null) {
            this.addCombinerParameters(combinerParametersIn);
        }
    }

    public void add(CombinerParameter combinerParameter) {
        this.ensureCombinerParameters();
        this.combinerParameters.add(combinerParameter);
    }

    public void addCombinerParameters(Collection<CombinerParameter> combinerParametersIn) {
        this.ensureCombinerParameters();
        this.combinerParameters.addAll(combinerParametersIn);
    }

    public Iterator<ObligationExpression> getObligationExpressions() {
        return this.obligationExpressions == null ? null : this.obligationExpressions.iterator();
    }

    public void setObligationExpressions(Collection<ObligationExpression> obligationExpressionsIn) {
        this.obligationExpressions = null;
        if (obligationExpressionsIn != null) {
            this.addObligationExpressions(obligationExpressionsIn);
        }
    }

    public void add(ObligationExpression obligationExpression) {
        this.ensureObligationExpressions();
        this.obligationExpressions.add(obligationExpression);
    }

    public void addObligationExpressions(Collection<ObligationExpression> obligationExpressionsIn) {
        this.ensureObligationExpressions();
        this.obligationExpressions.addAll(obligationExpressionsIn);
    }

    public Iterator<AdviceExpression> getAdviceExpressions() {
        return this.adviceExpressions == null ? null : this.adviceExpressions.iterator();
    }

    public void setAdviceExpressions(Collection<AdviceExpression> adviceExpressionsIn) {
        this.adviceExpressions = null;
        if (adviceExpressionsIn != null) {
            this.addAdviceExpressions(adviceExpressionsIn);
        }
    }

    public void add(AdviceExpression adviceExpression) {
        this.ensureAdviceExpressions();
        this.adviceExpressions.add(adviceExpression);
    }

    public void addAdviceExpressions(Collection<AdviceExpression> adviceExpressionsIn) {
        this.ensureAdviceExpressions();
        this.adviceExpressions.addAll(adviceExpressionsIn);
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version versionIn) {
        this.version = versionIn;
        this.idReference = null;
    }

    public IdReference getIdReference() {
        if (this.idReference == null) {
            this.idReference = new StdIdReference(this.getIdentifier(), this.getVersion());
        }
        return this.idReference;
    }

    public boolean matches(IdReferenceMatch idReferenceRequest) {
        VersionMatch idReferenceRequestLatestVersion;
        IdReference thisIdReference = this.getIdReference();
        if (thisIdReference == null || thisIdReference.getId() == null || idReferenceRequest == null || idReferenceRequest.getId() == null) {
            return false;
        }
        if (!thisIdReference.getId().equals((Object)idReferenceRequest.getId())) {
            return false;
        }
        VersionMatch idReferenceRequestVersion = idReferenceRequest.getVersion();
        if (idReferenceRequestVersion != null) {
            Version thisVersion = thisIdReference.getVersion();
            if (thisVersion == null) {
                return false;
            }
            return idReferenceRequestVersion.match(thisVersion, 0);
        }
        VersionMatch idReferenceRequestEarliestVersion = idReferenceRequest.getEarliestVersion();
        Version thisVersion = thisIdReference.getVersion();
        if (idReferenceRequestEarliestVersion != null) {
            if (thisVersion == null) {
                return false;
            }
            if (!idReferenceRequestEarliestVersion.match(thisVersion, 1)) {
                return false;
            }
        }
        if ((idReferenceRequestLatestVersion = idReferenceRequest.getLatestVersion()) != null) {
            if (thisVersion == null) {
                return false;
            }
            if (!idReferenceRequestLatestVersion.match(thisVersion, -1)) {
                return false;
            }
        }
        return true;
    }

    public Integer getMaxDelegationDepth() {
        return this.maxDelegationDepth;
    }

    public void setMaxDelegationDepth(Integer i) {
        this.maxDelegationDepth = i;
    }

    @Override
    public String toString() {
        String iteratorToString;
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getDescription();
        if (objectToDump != null) {
            stringBuilder.append(",description=");
            stringBuilder.append((String)objectToDump);
        }
        if ((objectToDump = this.getPolicyIssuer()) != null) {
            stringBuilder.append(",policyIssuer=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getTarget()) != null) {
            stringBuilder.append(",target=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((iteratorToString = StringUtils.toString(this.getCombinerParameters())) != null) {
            stringBuilder.append(",combinerParameters=");
            stringBuilder.append(iteratorToString);
        }
        if ((iteratorToString = StringUtils.toString(this.getObligationExpressions())) != null) {
            stringBuilder.append(",obligationExpressions=");
            stringBuilder.append(iteratorToString);
        }
        if ((iteratorToString = StringUtils.toString(this.getAdviceExpressions())) != null) {
            stringBuilder.append(",adviceExpressions=");
            stringBuilder.append(iteratorToString);
        }
        if ((objectToDump = this.getVersion()) != null) {
            stringBuilder.append(",version=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getMaxDelegationDepth()) != null) {
            stringBuilder.append(",maxDelegationDepth=");
            stringBuilder.append(objectToDump.toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public MatchResult match(EvaluationContext evaluationContext) throws EvaluationException {
        if (!this.validate()) {
            return new MatchResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        return this.getTarget().match(evaluationContext);
    }
}

