/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.IdReferenceMatch;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public abstract class PolicyIdReferenceBase<T extends PolicyDef>
extends PolicySetChild {
    private IdReferenceMatch idReferenceMatch;
    private T referencee;

    @Override
    protected boolean validateComponent() {
        if (super.validateComponent()) {
            if (this.getIdReferenceMatch() == null) {
                this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing reference id");
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract T ensureReferencee(EvaluationContext var1) throws EvaluationException;

    public PolicyIdReferenceBase(PolicySet policySetParent, StatusCode statusCodeIn, String statusMessageIn) {
        super(policySetParent, statusCodeIn, statusMessageIn);
    }

    public PolicyIdReferenceBase(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public PolicyIdReferenceBase(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public PolicyIdReferenceBase(PolicySet policySetParent) {
        super(policySetParent);
    }

    public PolicyIdReferenceBase() {
    }

    public IdReferenceMatch getIdReferenceMatch() {
        return this.idReferenceMatch;
    }

    public void setIdReferenceMatch(IdReferenceMatch idReferenceMatchIn) {
        this.idReferenceMatch = idReferenceMatchIn;
    }

    public T getReferencee() {
        return this.referencee;
    }

    public void setReferencee(T referenceeIn) {
        this.referencee = referenceeIn;
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext evaluationContext) throws EvaluationException {
        T thisReferencee = this.ensureReferencee(evaluationContext);
        if (thisReferencee == null) {
            return new EvaluationResult(Decision.INDETERMINATE, (Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Could not find referencee for " + this.getIdReferenceMatch().toString()));
        }
        return thisReferencee.evaluate(evaluationContext);
    }

    @Override
    public MatchResult match(EvaluationContext evaluationContext) throws EvaluationException {
        T thisReferencee = this.ensureReferencee(evaluationContext);
        if (thisReferencee == null) {
            return new MatchResult(MatchResult.MatchCode.INDETERMINATE, (Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Could not find referencee for " + this.getIdReferenceMatch().toString()));
        }
        return ((PolicyDef)thisReferencee).match(evaluationContext);
    }
}

