/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.trace.TraceEvent;
import org.apache.openaz.xacml.api.trace.Traceable;
import org.apache.openaz.xacml.pdp.eval.Evaluatable;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.eval.MatchResult;
import org.apache.openaz.xacml.pdp.eval.Matchable;
import org.apache.openaz.xacml.pdp.policy.AdviceExpression;
import org.apache.openaz.xacml.pdp.policy.Condition;
import org.apache.openaz.xacml.pdp.policy.ExpressionResultBoolean;
import org.apache.openaz.xacml.pdp.policy.ObligationExpression;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyComponent;
import org.apache.openaz.xacml.pdp.policy.RuleEffect;
import org.apache.openaz.xacml.pdp.policy.Target;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.trace.StdTraceEvent;
import org.apache.openaz.xacml.util.StringUtils;

public class Rule
extends PolicyComponent
implements Matchable,
Evaluatable,
Traceable {
    private Policy policy;
    private String ruleId;
    private RuleEffect ruleEffect;
    private String description;
    private Target target;
    private Condition condition;
    private List<ObligationExpression> obligationExpressions = new ArrayList<ObligationExpression>();
    private List<AdviceExpression> adviceExpressions = new ArrayList<AdviceExpression>();

    protected List<ObligationExpression> getObligationExpressionList() {
        return this.obligationExpressions;
    }

    protected void clearObligationExpressions() {
        this.getObligationExpressionList().clear();
    }

    protected List<AdviceExpression> getAdviceExpressionList() {
        return this.adviceExpressions;
    }

    protected void clearAdviceExpressions() {
        this.getAdviceExpressionList().clear();
    }

    public Rule(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public Rule(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public Rule() {
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policyIn) {
        this.policy = policyIn;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleIdIn) {
        this.ruleId = ruleIdIn;
    }

    public RuleEffect getRuleEffect() {
        return this.ruleEffect;
    }

    public void setRuleEffect(RuleEffect ruleEffectIn) {
        this.ruleEffect = ruleEffectIn;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descriptionIn) {
        this.description = descriptionIn;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target targetIn) {
        this.target = targetIn;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition conditionIn) {
        this.condition = conditionIn;
    }

    public Iterator<ObligationExpression> getObligationExpressions() {
        return this.obligationExpressions == null ? null : this.obligationExpressions.iterator();
    }

    public void setObligationExpressions(Collection<ObligationExpression> obligationExpressionsIn) {
        this.clearObligationExpressions();
        if (obligationExpressionsIn != null) {
            this.addObligationExpressions(obligationExpressionsIn);
        }
    }

    public void addObligationExpression(ObligationExpression obligationExpression) {
        this.getObligationExpressionList().add(obligationExpression);
    }

    public void addObligationExpressions(Collection<ObligationExpression> obligationExpressionsIn) {
        this.getObligationExpressionList().addAll(obligationExpressionsIn);
    }

    public Iterator<AdviceExpression> getAdviceExpressions() {
        return this.adviceExpressions == null ? null : this.adviceExpressions.iterator();
    }

    public void setAdviceExpressions(Collection<AdviceExpression> adviceExpressionsIn) {
        this.clearAdviceExpressions();
        if (adviceExpressionsIn != null) {
            this.addAdviceExpressions(adviceExpressionsIn);
        }
    }

    public void addAdviceExpression(AdviceExpression adviceExpression) {
        this.getAdviceExpressionList().add(adviceExpression);
    }

    public void addAdviceExpressions(Collection<AdviceExpression> adviceExpressionsIn) {
        this.getAdviceExpressionList().addAll(adviceExpressionsIn);
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext evaluationContext) throws EvaluationException {
        if (!this.validate()) {
            return new EvaluationResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        MatchResult matchResult = this.match(evaluationContext);
        if (evaluationContext.isTracing()) {
            evaluationContext.trace((TraceEvent)new StdTraceEvent("Match", (Traceable)this, (Object)matchResult));
        }
        switch (matchResult.getMatchCode()) {
            case INDETERMINATE: {
                return new EvaluationResult(Decision.INDETERMINATE, matchResult.getStatus());
            }
            case MATCH: {
                break;
            }
            case NOMATCH: {
                return new EvaluationResult(Decision.NOTAPPLICABLE);
            }
        }
        Condition thisCondition = this.getCondition();
        if (thisCondition != null) {
            ExpressionResultBoolean expressionResultCondition = thisCondition.evaluate(evaluationContext, this.getPolicy().getPolicyDefaults());
            assert (expressionResultCondition != null);
            if (evaluationContext.isTracing()) {
                evaluationContext.trace((TraceEvent)new StdTraceEvent("Condition", (Traceable)this, (Object)expressionResultCondition));
            }
            if (!expressionResultCondition.isOk()) {
                return new EvaluationResult(Decision.INDETERMINATE, expressionResultCondition.getStatus());
            }
            if (!expressionResultCondition.isTrue()) {
                return new EvaluationResult(Decision.NOTAPPLICABLE);
            }
        }
        List<Obligation> listObligations = ObligationExpression.evaluate(evaluationContext, this.getPolicy().getPolicyDefaults(), this.getRuleEffect().getDecision(), this.getObligationExpressionList());
        List<Advice> listAdvices = AdviceExpression.evaluate(evaluationContext, this.getPolicy().getPolicyDefaults(), this.getRuleEffect().getDecision(), this.getAdviceExpressionList());
        Collection<AttributeCategory> matchedAttributeCategories = matchResult.getMatchedAttributeCategories();
        EvaluationResult evaluationResult = new EvaluationResult(this.getRuleEffect().getDecision(), listObligations, listAdvices, matchedAttributeCategories, null, null);
        if (evaluationContext.isTracing()) {
            evaluationContext.trace((TraceEvent)new StdTraceEvent("Result", (Traceable)this, (Object)evaluationResult));
        }
        return evaluationResult;
    }

    @Override
    public MatchResult match(EvaluationContext evaluationContext) throws EvaluationException {
        if (!this.validate()) {
            return new MatchResult((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        Target thisTarget = this.getTarget();
        if (thisTarget != null) {
            return thisTarget.match(evaluationContext);
        }
        return MatchResult.MM_MATCH;
    }

    @Override
    protected boolean validateComponent() {
        if (this.getRuleId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing rule id");
            return false;
        }
        if (this.getPolicy() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Rule not in a Policy");
            return false;
        }
        if (this.getRuleEffect() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing effect");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        String iterToDump;
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getRuleId();
        if (objectToDump != null) {
            stringBuilder.append(",ruleId=");
            stringBuilder.append((String)objectToDump);
        }
        if ((objectToDump = this.getRuleEffect()) != null) {
            stringBuilder.append(",ruleEffect=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getDescription()) != null) {
            stringBuilder.append(",description=");
            stringBuilder.append((String)objectToDump);
        }
        if ((objectToDump = this.getTarget()) != null) {
            stringBuilder.append(",target=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getCondition()) != null) {
            stringBuilder.append(",condition=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((iterToDump = StringUtils.toString(this.getObligationExpressions())) != null) {
            stringBuilder.append(",obligationExpressions=");
            stringBuilder.append(iterToDump);
        }
        if ((iterToDump = StringUtils.toString(this.getAdviceExpressions())) != null) {
            stringBuilder.append(",adviceExpressions=");
            stringBuilder.append(iterToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public String getTraceId() {
        return this.getRuleId();
    }

    public Traceable getCause() {
        return this.policy;
    }
}

