/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.Match;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAttributeDesignator;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAttributeSelector;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMMatch
extends Match {
    private static Log logger = LogFactory.getLog(DOMMatch.class);

    protected DOMMatch() {
    }

    public static Match newInstance(Node nodeMatch) throws DOMStructureException {
        DOMMatch domMatch;
        block12: {
            Element elementMatch = DOMUtil.getElement((Node)nodeMatch);
            boolean bLenient = DOMProperties.isLenient();
            domMatch = new DOMMatch();
            try {
                int numChildren;
                NodeList children = elementMatch.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                            String childName = child.getLocalName();
                            if ("AttributeValue".equals(childName)) {
                                domMatch.setAttributeValue(DOMAttributeValue.newInstance((Node)child, null));
                                continue;
                            }
                            if ("AttributeDesignator".equals(childName)) {
                                if (domMatch.getAttributeRetrievalBase() != null && !bLenient) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeMatch);
                                }
                                domMatch.setAttributeRetrievalBase(DOMAttributeDesignator.newInstance(child));
                                continue;
                            }
                            if ("AttributeSelector".equals(childName)) {
                                if (domMatch.getAttributeRetrievalBase() != null) {
                                    throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeMatch);
                                }
                                domMatch.setAttributeRetrievalBase(DOMAttributeSelector.newInstance(child));
                                continue;
                            }
                            if (bLenient) continue;
                            throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeMatch);
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeMatch);
                    }
                }
                if (domMatch.getAttributeRetrievalBase() == null && !bLenient) {
                    throw DOMUtil.newMissingElementException((Node)nodeMatch, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeDesignator or AttributeSelector");
                }
                if (domMatch.getAttributeValue() == null && !bLenient) {
                    throw DOMUtil.newMissingElementException((Node)nodeMatch, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
                }
                domMatch.setMatchId(DOMUtil.getIdentifierAttribute((Node)elementMatch, (String)"MatchId", (!bLenient ? 1 : 0) != 0));
            }
            catch (DOMStructureException ex) {
                domMatch.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block12;
                throw ex;
            }
        }
        return domMatch;
    }

    public static boolean repair(Node nodeMatch) throws DOMStructureException {
        int numChildren;
        Element elementMatch = DOMUtil.getElement((Node)nodeMatch);
        boolean result = false;
        NodeList children = elementMatch.getChildNodes();
        boolean sawAttributeRetrievalBase = false;
        boolean sawAttributeValue = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("AttributeValue".equals(childName)) {
                        if (sawAttributeValue) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementMatch.removeChild(child);
                            result = true;
                            continue;
                        }
                        result = DOMAttributeValue.repair((Node)child) || result;
                        sawAttributeValue = true;
                        continue;
                    }
                    if ("AttributeDesignator".equals(childName)) {
                        if (sawAttributeRetrievalBase) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementMatch.removeChild(child);
                            result = true;
                            continue;
                        }
                        result = DOMAttributeDesignator.repair(child) || result;
                        sawAttributeRetrievalBase = true;
                        continue;
                    }
                    if ("AttributeSelector".equals(childName)) {
                        if (sawAttributeRetrievalBase) {
                            logger.warn((Object)("Unexpected element " + child.getNodeName()));
                            elementMatch.removeChild(child);
                            result = true;
                            continue;
                        }
                        result = DOMAttributeSelector.repair(child) || result;
                        sawAttributeRetrievalBase = true;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementMatch.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementMatch.removeChild(child);
                result = true;
            }
        }
        if (!sawAttributeRetrievalBase) {
            throw DOMUtil.newMissingElementException((Node)nodeMatch, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeDesignator or AttributeSelector");
        }
        if (!sawAttributeValue) {
            throw DOMUtil.newMissingElementException((Node)nodeMatch, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
        }
        result = DOMUtil.repairIdentifierAttribute((Element)elementMatch, (String)"MatchId", (Log)logger) || result;
        return result;
    }
}

