/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.TargetedCombinerParameter;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPolicyCombinerParameter
extends TargetedCombinerParameter<Identifier, PolicySetChild> {
    private static final Log logger = LogFactory.getLog(DOMPolicyCombinerParameter.class);

    protected DOMPolicyCombinerParameter() {
    }

    public static TargetedCombinerParameter<Identifier, PolicySetChild> newInstance(Node nodeCombinerParameter) throws DOMStructureException {
        DOMPolicyCombinerParameter domPolicyCombinerParameter;
        block6: {
            Element elementPolicyCombinerParameter = DOMUtil.getElement((Node)nodeCombinerParameter);
            boolean bLenient = DOMProperties.isLenient();
            domPolicyCombinerParameter = new DOMPolicyCombinerParameter();
            try {
                int numChildren;
                NodeList children = elementPolicyCombinerParameter.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeValue".equals(child.getLocalName())) {
                            domPolicyCombinerParameter.setAttributeValue(DOMAttributeValue.newInstance((Node)child, null));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeCombinerParameter);
                    }
                }
                if (domPolicyCombinerParameter.getAttributeValue() == null && !bLenient) {
                    throw DOMUtil.newMissingElementException((Node)nodeCombinerParameter, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
                }
                domPolicyCombinerParameter.setName(DOMUtil.getStringAttribute((Node)elementPolicyCombinerParameter, (String)"ParameterName", (!bLenient ? 1 : 0) != 0));
                domPolicyCombinerParameter.setTargetId(DOMUtil.getIdentifierAttribute((Node)elementPolicyCombinerParameter, (String)"PolicyIdRef", (!bLenient ? 1 : 0) != 0));
            }
            catch (DOMStructureException ex) {
                domPolicyCombinerParameter.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block6;
                throw ex;
            }
        }
        return domPolicyCombinerParameter;
    }

    public static boolean repair(Node nodePolicyCombinerParameter) throws DOMStructureException {
        int numChildren;
        Element elementPolicyCombinerParameter = DOMUtil.getElement((Node)nodePolicyCombinerParameter);
        boolean result = false;
        NodeList children = elementPolicyCombinerParameter.getChildNodes();
        boolean sawAttributeValue = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeValue".equals(child.getLocalName())) {
                    if (sawAttributeValue) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementPolicyCombinerParameter.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawAttributeValue = true;
                    result = DOMAttributeValue.repair((Node)child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementPolicyCombinerParameter.removeChild(child);
                result = true;
            }
        }
        if (!sawAttributeValue) {
            throw DOMUtil.newMissingElementException((Node)nodePolicyCombinerParameter, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
        }
        result = DOMUtil.repairStringAttribute((Element)elementPolicyCombinerParameter, (String)"ParameterName", (String)"parameter", (Log)logger) || result;
        result = DOMUtil.repairIdentifierAttribute((Element)elementPolicyCombinerParameter, (String)"PolicyIdRef", (Log)logger) || result;
        return result;
    }
}

