/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.policy.TargetedCombinerParameter;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRuleCombinerParameters
extends TargetedCombinerParameter<String, Rule> {
    private static final Log logger = LogFactory.getLog(DOMRuleCombinerParameters.class);

    protected DOMRuleCombinerParameters() {
    }

    public static TargetedCombinerParameter<String, Rule> newInstance(Node nodeRuleCombinerParameters) throws DOMStructureException {
        DOMRuleCombinerParameters domRuleCombinerParameters;
        block7: {
            Element elementRuleCombinerParameters = DOMUtil.getElement((Node)nodeRuleCombinerParameters);
            boolean bLenient = DOMProperties.isLenient();
            domRuleCombinerParameters = new DOMRuleCombinerParameters();
            try {
                int numChildren;
                NodeList children = elementRuleCombinerParameters.getChildNodes();
                if (children != null && (numChildren = children.getLength()) > 0) {
                    for (int i = 0; i < numChildren; ++i) {
                        Node child = children.item(i);
                        if (!DOMUtil.isElement((Node)child)) continue;
                        if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeValue".equals(child.getLocalName())) {
                            if (domRuleCombinerParameters.getAttributeValue() != null) {
                                throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRuleCombinerParameters);
                            }
                            domRuleCombinerParameters.setAttributeValue(DOMAttributeValue.newInstance((Node)child, null));
                            continue;
                        }
                        if (bLenient) continue;
                        throw DOMUtil.newUnexpectedElementException((Node)child, (Node)nodeRuleCombinerParameters);
                    }
                }
                if (domRuleCombinerParameters.getAttributeValue() == null && !bLenient) {
                    throw DOMUtil.newMissingElementException((Node)nodeRuleCombinerParameters, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
                }
                domRuleCombinerParameters.setName(DOMUtil.getStringAttribute((Node)elementRuleCombinerParameters, (String)"ParameterName", (!bLenient ? 1 : 0) != 0));
                domRuleCombinerParameters.setTargetId(DOMUtil.getStringAttribute((Node)elementRuleCombinerParameters, (String)"RuleIdRef", (!bLenient ? 1 : 0) != 0));
            }
            catch (DOMStructureException ex) {
                domRuleCombinerParameters.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, ex.getMessage());
                if (!DOMProperties.throwsExceptions()) break block7;
                throw ex;
            }
        }
        return domRuleCombinerParameters;
    }

    public static boolean repair(Node nodeRuleCombinerParameters) throws DOMStructureException {
        int numChildren;
        Element elementRuleCombinerParameters = DOMUtil.getElement((Node)nodeRuleCombinerParameters);
        boolean result = false;
        NodeList children = elementRuleCombinerParameters.getChildNodes();
        boolean sawAttributeValue = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement((Node)child)) continue;
                if (DOMUtil.isInNamespace((Node)child, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributeValue".equals(child.getLocalName())) {
                    if (sawAttributeValue) {
                        logger.warn((Object)("Unexpected element " + child.getNodeName()));
                        elementRuleCombinerParameters.removeChild(child);
                        result = true;
                        continue;
                    }
                    sawAttributeValue = true;
                    result = result || DOMAttributeValue.repair((Node)child);
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementRuleCombinerParameters.removeChild(child);
                result = true;
            }
        }
        if (!sawAttributeValue) {
            throw DOMUtil.newMissingElementException((Node)nodeRuleCombinerParameters, (String)"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", (String)"AttributeValue");
        }
        result = result || DOMUtil.repairStringAttribute((Element)elementRuleCombinerParameters, (String)"ParameterName", (String)"parameter", (Log)logger);
        result = result || DOMUtil.repairIdentifierAttribute((Element)elementRuleCombinerParameters, (String)"RuleIdRef", (Log)logger);
        return result;
    }
}

