/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.policy.expressions;

import java.util.Collection;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.MissingAttributeDetail;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.StatusDetail;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.PolicyDefaults;
import org.apache.openaz.xacml.pdp.policy.expressions.AttributeRetrievalBase;
import org.apache.openaz.xacml.std.StdMutableMissingAttributeDetail;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.StdStatusDetail;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;

public class AttributeDesignator
extends AttributeRetrievalBase {
    private Identifier attributeId;
    private String issuer;
    private PIPRequest pipRequestCached;
    private MissingAttributeDetail missingAttributeDetail;
    private StatusDetail statusDetail;

    protected PIPRequest getPIPRequest() {
        if (this.pipRequestCached == null) {
            this.pipRequestCached = new StdPIPRequest(this.getCategory(), this.getAttributeId(), this.getDataTypeId(), this.getIssuer());
        }
        return this.pipRequestCached;
    }

    protected MissingAttributeDetail getMissingAttributeDetail() {
        if (this.missingAttributeDetail == null) {
            this.missingAttributeDetail = new StdMutableMissingAttributeDetail(this.getCategory(), this.getAttributeId(), this.getDataTypeId(), this.getIssuer());
        }
        return this.missingAttributeDetail;
    }

    protected StatusDetail getStatusDetail() {
        if (this.statusDetail == null) {
            this.statusDetail = new StdStatusDetail(this.getMissingAttributeDetail());
        }
        return this.statusDetail;
    }

    public AttributeDesignator(StatusCode statusCodeIn, String statusMessageIn) {
        super(statusCodeIn, statusMessageIn);
    }

    public AttributeDesignator(StatusCode statusCodeIn) {
        super(statusCodeIn);
    }

    public AttributeDesignator() {
    }

    public Identifier getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(Identifier identifierAttributeId) {
        this.attributeId = identifierAttributeId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuerIn) {
        this.issuer = issuerIn;
    }

    @Override
    protected boolean validateComponent() {
        if (!super.validateComponent()) {
            return false;
        }
        if (this.getAttributeId() == null) {
            this.setStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Missing AttributeId");
            return false;
        }
        return true;
    }

    protected boolean match(Attribute attribute) {
        if (!this.getCategory().equals((Object)attribute.getCategory())) {
            return false;
        }
        if (!this.getAttributeId().equals((Object)attribute.getAttributeId())) {
            return false;
        }
        return this.getIssuer() == null || this.getIssuer().equals(attribute.getIssuer());
    }

    protected boolean match(AttributeValue<?> attributeValue) {
        return this.getDataTypeId().equals((Object)attributeValue.getDataTypeId());
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, PolicyDefaults policyDefaults) throws EvaluationException {
        if (!this.validate()) {
            return ExpressionResult.newInstance((Status)new StdStatus(this.getStatusCode(), this.getStatusMessage()));
        }
        PIPRequest pipRequest = this.getPIPRequest();
        assert (pipRequest != null);
        PIPResponse pipResponse = null;
        try {
            pipResponse = evaluationContext.getAttributes(pipRequest);
        }
        catch (PIPException ex) {
            throw new EvaluationException("PIPException getting Attributes", ex);
        }
        assert (pipResponse != null);
        Status pipStatus = pipResponse.getStatus();
        if (pipStatus != null && !pipStatus.getStatusCode().equals((Object)StdStatusCode.STATUS_CODE_OK)) {
            return ExpressionResult.newInstance(pipStatus);
        }
        Bag bagAttributeValues = new Bag();
        Collection listAttributes = pipResponse.getAttributes();
        for (Attribute attribute : listAttributes) {
            if (!this.match(attribute)) continue;
            for (AttributeValue attributeValue : attribute.getValues()) {
                if (!this.match(attributeValue)) continue;
                bagAttributeValues.add(attributeValue);
            }
        }
        if (this.getMustBePresent().booleanValue() && bagAttributeValues.size() == 0) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_MISSING_ATTRIBUTE, "Missing required attribute", (StatusDetail)new StdStatusDetail(this.getMissingAttributeDetail())));
        }
        return ExpressionResult.newBag(bagAttributeValues);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        stringBuilder.append("super=");
        stringBuilder.append(super.toString());
        Object objectToDump = this.getAttributeId();
        if (objectToDump != null) {
            stringBuilder.append(",attributeId=");
            stringBuilder.append(objectToDump.toString());
        }
        if ((objectToDump = this.getIssuer()) != null) {
            stringBuilder.append(",issuer=");
            stringBuilder.append((String)objectToDump);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

