/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPFinderFactory;
import org.apache.openaz.xacml.api.trace.TraceEngine;
import org.apache.openaz.xacml.api.trace.TraceEngineFactory;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationContextFactory;
import org.apache.openaz.xacml.pdp.policy.PolicyFinder;
import org.apache.openaz.xacml.pdp.policy.PolicyFinderFactory;
import org.apache.openaz.xacml.pdp.std.StdEvaluationContext;

public class StdEvaluationContextFactory
extends EvaluationContextFactory {
    private Log logger = LogFactory.getLog(this.getClass());
    private PolicyFinder policyFinder;
    private PIPFinder pipFinder;
    private TraceEngine traceEngine;
    protected Properties properties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PolicyFinder getPolicyFinder() {
        if (this.policyFinder == null) {
            StdEvaluationContextFactory stdEvaluationContextFactory = this;
            synchronized (stdEvaluationContextFactory) {
                if (this.policyFinder == null) {
                    try {
                        if (this.properties == null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)"getting Policy finder using default properties");
                            }
                            PolicyFinderFactory policyFinderFactory = PolicyFinderFactory.newInstance();
                            this.policyFinder = policyFinderFactory.getPolicyFinder();
                        } else {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("getting Policy finder using properties: " + this.properties));
                            }
                            PolicyFinderFactory policyFinderFactory = PolicyFinderFactory.newInstance(this.properties);
                            this.policyFinder = policyFinderFactory.getPolicyFinder(this.properties);
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)("Exception getting PolicyFinder: " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
        }
        return this.policyFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PIPFinder getPIPFinder() {
        if (this.pipFinder == null) {
            StdEvaluationContextFactory stdEvaluationContextFactory = this;
            synchronized (stdEvaluationContextFactory) {
                if (this.pipFinder == null) {
                    try {
                        if (this.properties == null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)"getting PIP finder using default properties");
                            }
                            PIPFinderFactory pipFinderFactory = PIPFinderFactory.newInstance();
                            this.pipFinder = pipFinderFactory.getFinder();
                        } else {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("getting PIP finder using properties: " + this.properties));
                            }
                            PIPFinderFactory pipFinderFactory = PIPFinderFactory.newInstance((Properties)this.properties);
                            this.pipFinder = pipFinderFactory.getFinder(this.properties);
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)("Exception getting PIPFinder: " + ex.toString()), (Throwable)ex);
                    }
                }
            }
        }
        return this.pipFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TraceEngine getTraceEngine() {
        if (this.traceEngine == null) {
            StdEvaluationContextFactory stdEvaluationContextFactory = this;
            synchronized (stdEvaluationContextFactory) {
                if (this.traceEngine == null) {
                    try {
                        TraceEngineFactory traceEngineFactory = TraceEngineFactory.newInstance();
                        this.traceEngine = traceEngineFactory.getTraceEngine();
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)("Exception getting TraceEngine: " + ex.toString()), (Throwable)ex);
                    }
                }
            }
        }
        return this.traceEngine;
    }

    public StdEvaluationContextFactory() {
    }

    public StdEvaluationContextFactory(Properties properties) {
        this.properties = properties;
    }

    @Override
    public EvaluationContext getEvaluationContext(Request request) {
        return new StdEvaluationContext(request, this.getPolicyFinder(), this.getPIPFinder(), this.getTraceEngine());
    }

    @Override
    public void setPolicyFinder(PolicyFinder policyFinderIn) {
        this.policyFinder = policyFinderIn;
    }

    @Override
    public void setPIPFinder(PIPFinder pipFinderIn) {
        this.pipFinder = pipFinderIn;
    }
}

