/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.combiners;

import java.util.List;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.eval.Evaluatable;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.pdp.policy.CombiningElement;
import org.apache.openaz.xacml.pdp.std.combiners.CombiningAlgorithmBase;

public class DenyUnlessPermit<T extends Evaluatable>
extends CombiningAlgorithmBase<T> {
    public DenyUnlessPermit(Identifier identifierIn) {
        super(identifierIn);
    }

    @Override
    public EvaluationResult combine(EvaluationContext evaluationContext, List<CombiningElement<T>> elements, List<CombinerParameter> combinerParameters) throws EvaluationException {
        EvaluationResult combinedResult = new EvaluationResult(Decision.DENY);
        block5: for (CombiningElement<T> combiningElement : elements) {
            EvaluationResult evaluationResultElement = combiningElement.evaluate(evaluationContext);
            assert (evaluationResultElement != null);
            switch (evaluationResultElement.getDecision()) {
                case DENY: {
                    combinedResult.merge(evaluationResultElement);
                    continue block5;
                }
                case INDETERMINATE: 
                case INDETERMINATE_DENYPERMIT: 
                case INDETERMINATE_DENY: 
                case INDETERMINATE_PERMIT: 
                case NOTAPPLICABLE: {
                    continue block5;
                }
                case PERMIT: {
                    return evaluationResultElement;
                }
            }
            throw new EvaluationException("Illegal Decision: \"" + evaluationResultElement.getDecision().toString());
        }
        return combinedResult;
    }
}

