/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.combiners;

import java.util.List;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.eval.EvaluationException;
import org.apache.openaz.xacml.pdp.eval.EvaluationResult;
import org.apache.openaz.xacml.pdp.policy.CombinerParameter;
import org.apache.openaz.xacml.pdp.policy.CombiningElement;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.std.combiners.CombiningAlgorithmBase;
import org.apache.openaz.xacml.std.StdStatus;

public class LegacyDenyOverridesPolicy
extends CombiningAlgorithmBase<PolicySetChild> {
    public LegacyDenyOverridesPolicy(Identifier identifierIn) {
        super(identifierIn);
    }

    @Override
    public EvaluationResult combine(EvaluationContext evaluationContext, List<CombiningElement<PolicySetChild>> elements, List<CombinerParameter> combinerParameters) throws EvaluationException {
        boolean atLeastOnePermit = false;
        EvaluationResult combinedResult = new EvaluationResult(Decision.PERMIT);
        block6: for (CombiningElement<PolicySetChild> combiningElement : elements) {
            EvaluationResult evaluationResultElement = combiningElement.evaluate(evaluationContext);
            assert (evaluationResultElement != null);
            switch (evaluationResultElement.getDecision()) {
                case DENY: {
                    return evaluationResultElement;
                }
                case INDETERMINATE: 
                case INDETERMINATE_DENYPERMIT: 
                case INDETERMINATE_DENY: 
                case INDETERMINATE_PERMIT: {
                    return new EvaluationResult(Decision.DENY, StdStatus.STATUS_OK);
                }
                case NOTAPPLICABLE: {
                    continue block6;
                }
                case PERMIT: {
                    atLeastOnePermit = true;
                    combinedResult.merge(evaluationResultElement);
                    continue block6;
                }
            }
            throw new EvaluationException("Illegal Decision: \"" + evaluationResultElement.getDecision().toString());
        }
        if (atLeastOnePermit) {
            return combinedResult;
        }
        return new EvaluationResult(Decision.NOTAPPLICABLE);
    }
}

