/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdRequest;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.dom.DOMRequestAttributes;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FunctionDefinitionAccessPermitted
extends FunctionDefinitionBase<Boolean, URI> {
    public FunctionDefinitionAccessPermitted(Identifier idIn) {
        super(idIn, DataTypes.DT_BOOLEAN, DataTypes.DT_ANYURI, false);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        if (arguments == null || arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 2 arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        FunctionArgument functionArgument = arguments.get(0);
        ConvertedArgument convertedArgument0 = new ConvertedArgument(functionArgument, DataTypes.DT_ANYURI, false);
        if (!convertedArgument0.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedArgument0.getStatus()));
        }
        URI attributesURI = (URI)convertedArgument0.getValue();
        if (!attributesURI.toString().startsWith("urn:") || !attributesURI.toString().contains(":attribute-category:")) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, this.getShortFunctionId() + " First argument must be a urn for an attribute-category, not '" + attributesURI.toString()));
        }
        functionArgument = arguments.get(1);
        ConvertedArgument convertedArgument1 = new ConvertedArgument(functionArgument, DataTypes.DT_STRING, false);
        if (!convertedArgument1.isOk()) {
            return ExpressionResult.newError(this.getFunctionStatus(convertedArgument1.getStatus()));
        }
        String xmlContent = (String)convertedArgument1.getValue();
        if (!xmlContent.trim().toLowerCase().startsWith("<content>")) {
            xmlContent = "<Content>" + xmlContent + "</Content>";
        }
        Element newContentNode = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(xmlContent.getBytes());){
            Document doc = DOMUtil.loadDocument((InputStream)is);
            if (doc != null) {
                newContentNode = doc.getDocumentElement();
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, this.getShortFunctionId() + " Parsing of XML string failed.  Cause='" + message + "'"));
        }
        RequestAttributes newRequestAttributes = null;
        try {
            newRequestAttributes = DOMRequestAttributes.newInstance((Node)newContentNode);
        }
        catch (DOMStructureException e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, this.getShortFunctionId() + " Conversion of XML to RequestAttributes failed.  Cause='" + message + "'"));
        }
        if (evaluationContext == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Got null EvaluationContext"));
        }
        if (evaluationContext.getRequest() == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Got null Request in EvaluationContext"));
        }
        Request originalRequest = evaluationContext.getRequest();
        StdRequest newRequest = new StdRequest(originalRequest);
        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Not Implemented"));
    }
}

