/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionHomogeneousSimple;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypeString;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionStringNormalize
extends FunctionDefinitionHomogeneousSimple<String, String> {
    private final OPERATION operation;
    AttributeValue<String> result;

    public FunctionDefinitionStringNormalize(Identifier idIn, OPERATION op) {
        super(idIn, DataTypes.DT_STRING, DataTypeString.newInstance(), 1);
        this.operation = op;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        ArrayList convertedArguments = new ArrayList();
        Status status = this.validateArguments(arguments, convertedArguments);
        if (!status.getStatusCode().equals((Object)StdStatusCode.STATUS_CODE_OK)) {
            return ExpressionResult.newError(this.getFunctionStatus(status));
        }
        ExpressionResult expressionResult = null;
        switch (this.operation) {
            case SPACE: {
                this.result = new StdAttributeValue(XACML.ID_DATATYPE_STRING, (Object)((String)convertedArguments.get(0)).trim());
                break;
            }
            case LOWER_CASE: {
                this.result = new StdAttributeValue(XACML.ID_DATATYPE_STRING, (Object)((String)convertedArguments.get(0)).toLowerCase());
            }
        }
        expressionResult = ExpressionResult.newSingle(this.result);
        return expressionResult;
    }

    public static enum OPERATION {
        SPACE,
        LOWER_CASE;

    }
}

